/*
 * dia_Queue.h
 *
 *  Created on: 27.11.2014
 *      Author: gib2hi
 */


#ifndef __INCLUDED_DIA_QUEUE__
#define __INCLUDED_DIA_QUEUE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_QUEUE_IMPL__
#include "common/framework/application/dia_QueueImpl.h"
#endif

const tU32 DIA_C_U32_QUEUE_TIMEOUT =
#ifndef __DIA_UNIT_TESTING__
((tU32) 0xFFFFFFFF);   //DISABLED
#else
((tU32) 10*1000 );        // Set to 10 seconds, 1 second is too little because of many traces (main thread needs more time).
#endif

template <class _T>
class dia_Queue
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_Queue);

public:

   //! class constructor
   dia_Queue ( tCString queueName, tU16 queueSize ) : mBody(queueName,queueSize,(tU16) sizeof(_T*)),uid(cnt++)
   {
#ifdef __DIA_UNIT_TESTING__
      DIA_TR_INF("dia_Queue::dia_Queue(queueName=%s, queueSize=%u)", queueName, queueSize);
#endif
   }

   //! class destructor
   virtual ~dia_Queue ( void ) { (void) close(); }

   /*virtual*/ tDiaResult open ( void ) { return mBody.open(); }
   /*virtual*/ tDiaResult close ( void )  { return mBody.close(); }
   /*virtual*/ tDiaResult addElement ( _T&  element ) { return mBody.addElement<_T>(/*(void*)*/ &element); }
   /*virtual*/ tDiaResult addElement ( _T* pElement ) { return mBody.addElement<_T>(/*(void*)*/ pElement); }
   /*virtual*/ tDiaResult getElement ( _T** ppElement, tU32 timeoutMSec = DIA_C_U32_QUEUE_TIMEOUT ) { return mBody.getElement<_T>(ppElement,timeoutMSec); }
   /*virtual*/ tU32 getSize ( void ) const { return mBody.getSize<_T>(); }

protected:
   dia_QueueImpl mBody;
   const dia_UID uid;

   static tU32 cnt;
};

template <class _T>
tU32 dia_Queue<_T>::cnt = 0;

#endif

//template<class _T> tDiaResult
//dia_SystemAdapterFacade::queryInterface ( _T** pInterface )
//{
//    tDiaResult retCode = DIA_FAILED;
//
//    if ( pInterface )
//    {
//        *pInterface = static_cast<_T*>(mInterfaceRep[_T::getUID()]);
//
//        if ( *pInterface )
//        {
//            retCode = DIA_SUCCESS;
//        }
//        else
//        {
//            retCode = DIA_E_INTERFACE_ID_MISMATCH;
//        }
//    }
//
//    return retCode;
//}
