/**
 * \file      dia_PredicateRunlevel.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 30, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_PREDICATE_RUNLEVEL__
#include <common/framework/application/dia_PredicateRunlevel.h>
#endif

#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include <common/framework/application/dia_AppController.h>
#endif

using namespace dia;

//-----------------------------------------------------------------------------

dia_PredicateRunlevel::dia_PredicateRunlevel ( dia_enRunlevel runlevel )
   : dia_Predicate(dia_PredicateRunlevel::getClassIdentifier()),
     mRunlevel(runlevel)
{
   std::string str = dia_composeStlString("%s_%d",dia_PredicateRunlevel::getClassName(),(int) runlevel);
   mUID = dia_getHashCodeFromString(str);
}

//-----------------------------------------------------------------------------

dia_PredicateRunlevel::dia_PredicateRunlevel ( const dia_PredicateRunlevel& obj )
   : dia_Predicate(obj),
     mRunlevel(obj.mRunlevel)
{}

//-----------------------------------------------------------------------------

dia_PredicateRunlevel&
dia_PredicateRunlevel::operator = ( const dia_PredicateRunlevel& obj )
{
   if ( this != &obj )
   {
      mUID       = obj.mUID;
      mClassID   = obj.mClassID;
      mIsMatched = obj.mIsMatched;
      mRunlevel  = obj.mRunlevel;
   }
   return *this;
}
//-----------------------------------------------------------------------------

dia_PredicateRunlevel::~dia_PredicateRunlevel ( void )
{}

//-----------------------------------------------------------------------------

dia_Predicate*
dia_PredicateRunlevel::clone (void )
{
   return new dia_PredicateRunlevel(*this);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_PredicateRunlevel::match ( void )
{
   ScopeTrace trc("dia_tclPredicateRunlevel::bMatch()");

   tDiaResult retCode = DIA_FAILED;

   dia_AppController* pAppCtrl = getInstanceOfAppController();
   if ( pAppCtrl )
   {
       if ( mRunlevel <= pAppCtrl->getRunLevel() )
       {
           DIA_TR_INF("###################################################################");
           DIA_TR_INF("#");
           DIA_TR_INF("# dia_PredicateRunlevel::bMatch: RUNLEVEL %d MATCHED", mRunlevel );
           DIA_TR_INF("#");
           DIA_TR_INF("###################################################################");
           retCode    = DIA_SUCCESS;
           mIsMatched = TRUE;
       }
   }

   return retCode;
}


//-----------------------------------------------------------------------------

void
dia_PredicateRunlevel::update ( const std::vector<tU32>& args )
{
   ScopeTrace trc("dia_tclPredicateRunlevel::bMatch()");

   if ( !(args.size()) ) return;
   if ( args[0] >= DIA_EN_RUNLEVEL_COUNT ) return;

   if ( mRunlevel <= ((dia_enRunlevel) args[0]) )
   {
      DIA_TR_INF("###################################################################");
      DIA_TR_INF("#");
      DIA_TR_INF("# dia_PredicateRunlevel::update: RUNLEVEL %d MATCHED", mRunlevel );
      DIA_TR_INF("#");
      DIA_TR_INF("###################################################################");
      mIsMatched = TRUE;
   }
}
