/*!
* \file       dia::PredicateOpMode.h
*
* \brief      Pre-service handler for all diag services
*             defer processing of UDS requests until required Init level is reached
*
*
* \component  Diagnosis
*
* \ingroup    diaCoreProtocols
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/


#ifndef __INCLUDED_DIA_PREDICATE_OPMODE__
#define __INCLUDED_DIA_PREDICATE_OPMODE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_PREDICATE__
#include <common/framework/application/dia_Predicate.h>
#endif

#ifndef __INCLUDE_DIA_OPMODE__
#include "common/framework/application/dia_OpMode.h"
#endif

#define DIA_PRED_OPMODE "DIA_PREDICATE_CLASS_OPMODE"

namespace dia {
//-----------------------------------------------------------------------------
class PredicateOpMode
  : public dia_Predicate
{

  DIA_DECL_PREDICATE_CLASS(DIA_PRED_OPMODE);

public:

  //! deprecated default class constructor
  PredicateOpMode(dia::UID sccOpMode);
  //! copy constructor
  PredicateOpMode(const PredicateOpMode& obj);
  //! assignment operator
  PredicateOpMode& operator = (const PredicateOpMode& obj);
  //! destructor
  virtual ~PredicateOpMode(void);

  //! check if the predicate is matched
  virtual tDiaResult match(void);
  //! observer pattern
  virtual void update(const std::vector<tU32>& args);
  //! prototype pattern
  virtual dia_Predicate* clone(void);

  virtual dia::UID getCurrOpMode(void) const { return mCurrOpMode; }

protected:
  //! deprecated default constructor without implementation
  PredicateOpMode(void);

protected:
  //! Current Opmode that needs to be matched
  dia::UID mCurrOpMode = DIA_UID_OPMODE_UNKOWN;
};

}
#endif /* __INCLUDED_DIA_PREDICATE_OPMODE__ */
