/*!
* \file       dia::PredicateOpMode.cpp
*
* \brief      Pre-service handler for all diag services
*             defer processing of UDS requests until required Init level is reached
*
*
* \component  Diagnosis
*
* \ingroup    diaCoreProtocols
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

#ifndef __INCLUDED_DIA_PREDICATE_OPMODE__
#include "dia_PredicateOpMode.h"
#endif

using namespace dia;

//-----------------------------------------------------------------------------

PredicateOpMode::PredicateOpMode(dia::UID sccOpMode)
        : dia_Predicate(PredicateOpMode::getClassIdentifier()),
          mCurrOpMode(sccOpMode)
{
   std::string str = dia_composeStlString("%s_%d", PredicateOpMode::getClassName(), sccOpMode);
   mUID = dia_getHashCodeFromString(str);
}

//-----------------------------------------------------------------------------

PredicateOpMode::PredicateOpMode(const PredicateOpMode& obj)
         : dia_Predicate(obj),
         mCurrOpMode(obj.mCurrOpMode)
{}

//-----------------------------------------------------------------------------

PredicateOpMode&
PredicateOpMode::operator = (const PredicateOpMode& obj)
{
   if (this != &obj)
   {
      mUID = obj.mUID;
      mClassID = obj.mClassID;
      mIsMatched = obj.mIsMatched;
      mCurrOpMode = obj.mCurrOpMode;
   }
   return *this;
}
//-----------------------------------------------------------------------------

PredicateOpMode::~PredicateOpMode(void)
{}

//-----------------------------------------------------------------------------

dia_Predicate*
PredicateOpMode::clone(void)
{
   return new PredicateOpMode(*this);
}

//-----------------------------------------------------------------------------

tDiaResult
PredicateOpMode::match(void)
{
   ScopeTrace trc("PredicateOpMode::bMatch()");

   tDiaResult retCode = DIA_FAILED;

   if (mCurrOpMode == dia::OpMode::getActiveOpMode())
   {
      DIA_TR_INF("# PredicateOpMode::bMatch: OPMODE %d MATCHED", mCurrOpMode);
      retCode = DIA_SUCCESS;
      mIsMatched = TRUE;
   }
   return retCode;
}


//-----------------------------------------------------------------------------

void
PredicateOpMode::update(const std::vector<tU32>& args)
{
   ScopeTrace trc("PredicateOpMode::bMatch()");

   if (!(args.size())) return;
   if (args[0] == DIA_UID_OPMODE_UNKOWN) return;


   if ((args[0]) != DIA_UID_OPMODE_UNKOWN)
   {
      mCurrOpMode = args[0];
      DIA_TR_INF("# PredicateOpMode::update: OPMODE %d MATCHED", mCurrOpMode);
      mIsMatched = TRUE;
   }
}
