/*!
* \file       dia::OpMode.h
*
* \brief      Class to synchronize Operation Mode information from SCC
*
* \component  Diagnosis
*
* \ingroup    diaCoreAppFrw
*
* \copyright  (c) 2018 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*/

#ifndef __INCLUDE_DIA_OPMODE__
#define __INCLUDE_DIA_OPMODE__

#ifndef __INCLUDED_DIA_INTERFACE_OPMODE_LISTENER__
#include <common/interfaces/dia_IOpModeListener.h>
#endif

//! List of OPMODE BitMasks
#define DIA_OPMODE_UNKOWN   ((tU8)      0xFF)
#define DIA_OPMODE_0        ((tU8)      0x00)
#define DIA_OPMODE_1        ((tU8)      0x01)
#define DIA_OPMODE_2        ((tU8)      0x02)

//! List of OPMODE UIDs
#define DIA_UID_OPMODE_UNKOWN  ((dia::UID)    0x1b383c78)
#define DIA_UID_OPMODE_0       ((dia::UID)    0x4ff22226)
#define DIA_UID_OPMODE_1       ((dia::UID)    0x4ff22227)
#define DIA_UID_OPMODE_2       ((dia::UID)    0x4ff22228)

namespace dia {

class OpMode : public dia_IOpModeListenerImpl
{
public:
   //! Class constructor
   //OpMode( void );
   //! Check if the requested OpMode is same as the Currently active OpMode.
   static bool isSynchronized ( void ) { return (mOpModeActive == mOpModeRequested); }
   //! Add a mapping to a corresponding Opmode bit mask.
   static void addMapping ( UID uid, tU8 bitMask )  { OpMode::mOpModeMapping[uid] = bitMask; }
   //! Return the Opmode bitmask corresponding to Opmode UID
   static tU8 getMapping( UID uid) { return OpMode::mOpModeMapping[uid]; }
   //! Update Currently Active Opmode
   virtual void vOnOpMode (UID newOpMode, UID oldOpMode) { mOpModeActive = oldOpMode; mOpModeRequested = newOpMode; }
   //! Current Opmode UID
   static UID getActiveOpMode ( void ) {return mOpModeActive;}
   //! Previous Opmode UID
   static UID getPreviousOpMode ( void ) {return mOpModeRequested;}

protected:
   static UID mOpModeActive;
   static UID mOpModeRequested;
   //! mapping of UIDs to SCC_INC Bit mask Values
   using OpmodeMap = std::map<UID,tU8>;
   static OpmodeMap mOpModeMapping;
};
}

#endif //__INCLUDE_DIA_OPMODE__
