/*
 * \file        dia_Object.h
 *
 * \brief       Foundation class providing reference counting services
 *
 * \details     None
 *
 * \author      gib2hi
 * \date        22.01.2011
 *
 * \copyright   Robert Bosch Car Multimedia 2011
 *
 */

#ifndef __INCLUDED_DIA_OBJECT__
#define __INCLUDED_DIA_OBJECT__

#ifndef __INCLUDED_DIA_INTERFACE_REFCOUNTABLE__
#include "common/interfaces/dia_IRefCountable.h"
#endif

/**
 * \class   dia::Object
 *
 * \brief   Foundation class providing reference counting services
 *
 *          This foundation class implements the dia_IRefCountable interface and
 *          therefore provides reference count handling to subclasses.
 *
 * \see     dia_IRefCountable
 *
 * \ingroup diaCoreAppFrw
 */

namespace dia {

class Object
    : public virtual dia_IRefCountable
{
public:
   //! default class constructor
   Object ( void ) : mRefCount(0) {}
   //! copy constructor
   Object ( const Object& obj );
   //! assignment operator
   Object& operator = (const Object& obj)= delete;

   //! class destructor
   virtual ~Object ( void ) {}

   /**
    * \brief increment the reference counter
    *
    * See \ref dia_IRefCountable::addRef()
    *
    */
   virtual void addRef ( void ) { mRefCount++; }

   //! decrement the reference counter
   virtual void releaseRef ( void ) { if ( mRefCount ) mRefCount--; }
   //! return the reference counter value
   virtual tU16 getRefCount ( void ) { return mRefCount; }

protected:
   //! reference counter for this object
   tU16 mRefCount;
};

}

typedef dia::Object dia_Object;

#endif
