/*!
 * \file       dia_Notifier.h
 *
 * \brief      Template class used to broadcast notification to a defined set of listeners
 *
 * \details    Template class used to broadcast notification to a defined set of listeners
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2011-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_NOTIFIER__
#define __INCLUDED_DIA_NOTIFIER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia {

//-----------------------------------------------------------------------------

class NotifierBase
   : public virtual dia_Object
{
public:
   NotifierBase ( void );
   virtual ~NotifierBase ( void );

   //! clear the respository of listeners
   void clear ( void );

   //! attach a new listener to this notifier
   virtual tDiaResult attachListener ( void* pListener );
   //! detach the given listener from the repository
   virtual tDiaResult detachListener ( void* pListener );
   //! merge registered listeners from given notifier object
   void mergeListeners ( const dia::NotifierBase& notifier );

   //! return list of listener registered at the notifier object
   const std::list<void*>& getListeners ( void ) const;

protected:
   std::list<void*> mListenerRep;
};

}

template <typename _T>
class dia_Notifier
   : public dia::NotifierBase
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_Notifier);

public:
   //! class constructor
   dia_Notifier ( void ) {}
   //! class destructor
   virtual ~dia_Notifier ( void ) {}

   //! attach a new listener to this notifier
   virtual tDiaResult attachListener ( _T* pListener ) { return dia::NotifierBase::attachListener((void*) pListener); }
   //! detach the given listener from the repository
   virtual tDiaResult detachListener ( _T* pListener ) { return dia::NotifierBase::detachListener((void*) pListener); }

protected:
   //! convert void* back to concrete type
   _T* convertListenerType ( void* pListener ) { return (_T*) pListener; }
};

#define DIA_M_ADD_NOTIFIER_ERROR_INFO() \
   virtual tVoid vOnError ( const dia_ErrorInfo& errInfo ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->vOnError(errInfo); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_ERROR_INFO_INTERFACE() \
   virtual tVoid vOnError ( const dia_ErrorInfoInterface& errInfoInterface ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->vOnError(errInfoInterface); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_NO_ARG(funcName) \
   virtual void funcName ( void ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(); \
      } \
    }

#define DIA_M_ADD_NOTIFIER_ONE_ARG(funcName,pType1) \
   virtual void funcName ( pType1 p1 ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(p1); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_ONE_ARG_REF(funcName,pType1) \
   virtual void funcName ( pType1 & p1 ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(p1); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_TWO_ARG(funcName,pType1,pType2) \
   virtual void funcName ( pType1 p1, pType2 p2 ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(p1,p2); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_THREE_ARG(funcName,pType1,pType2,pType3) \
   virtual void funcName ( pType1 p1, pType2 p2, pType3 p3 ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(p1,p2,p3); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_FOUR_ARG(funcName,pType1,pType2,pType3,pType4) \
   virtual tVoid funcName ( pType1 p1, pType2 p2, pType3 p3, pType4 p4 ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(p1,p2,p3,p4); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_FIVE_ARG(funcName,pType1,pType2,pType3,pType4,pType5) \
   virtual tVoid funcName ( pType1 p1, pType2 p2, pType3 p3, pType4 p4, pType5 p5 ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(p1,p2,p3,p4,p5); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_SIX_ARG(funcName,pType1,pType2,pType3,pType4,pType5,pType6) \
   virtual tVoid funcName ( pType1 p1, pType2 p2, pType3 p3, pType4 p4, pType5 p5, pType6 p6 ) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(p1,p2,p3,p4,p5,p6); \
      } \
   }

#define DIA_M_ADD_NOTIFIER_SEVEN_ARG(funcName,pType1,pType2,pType3,pType4,pType5,pType6,pType7) \
   virtual tVoid funcName ( pType1 p1, pType2 p2, pType3 p3, pType4 p4 , pType5 p5, pType6 p6, pType7 p7) \
   { \
      std::list<void*> listenerRep = mListenerRep; \
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it ) \
      { \
         if ( *it ) convertListenerType(*it)->funcName(p1,p2,p3,p4,p5,p6,p7); \
      } \
   }

#endif
