/*!
 * \file       dia_LockScope.cpp
 *
 * \brief      Locking class used for scoped locking in multiple thread environments
 *
 * \details    Locking class used for scoped locking in multiple thread environments
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2012-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include <common/framework/application/dia_LockScope.h>
#endif

namespace dia {

//------------------------------------------------------------------------------

LockScope::LockScope ( Lock& rLock )
   : mLock(rLock)
{
#ifdef VARIANT_S_FTR_ENABLE_RECURSIVE_LOCK
   mLock.lock();
#else
   DIA_TR_ERR("SCOPED LOCKING DISABLED -- NO RECURSIVE MUTEX !!!");
#endif
}

//------------------------------------------------------------------------------

LockScope::~LockScope ( void )
{
#ifdef VARIANT_S_FTR_ENABLE_RECURSIVE_LOCK
   _BP_TRY_BEGIN
   {
      mLock.unlock();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia::LockScope::~LockScope !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
#else
   DIA_TR_ERR("SCOPED LOCKING DISABLED -- NO RECURSIVE MUTEX !!!");
#endif
}

}
