/*
 * dia_InitializationLevel.h
 *
 *  Created on: 01.09.2017
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_INITIALIZATION_LEVEL__
#define __INCLUDED_DIA_INITIALIZATION_LEVEL__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

namespace dia {

class InitializationLevel
   : public ObjectWithUID
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(InitializationLevel);

public:
   InitializationLevel ( std::string& levelName, dia_enInitLevel levelID );
   InitializationLevel ( const char* levelName, dia_enInitLevel levelID );

   virtual ~InitializationLevel ( void );

   bool operator == ( const InitializationLevel& level );
   bool operator != ( const InitializationLevel& level );
   bool operator <= ( const InitializationLevel& level );
   bool operator <  ( const InitializationLevel& level );
   bool operator >= ( const InitializationLevel& level );
   bool operator >  ( const InitializationLevel& level );

   static const std::list<InitializationLevel*>& getInitializationLevels ( void ) { return mLevelSequence; }
   //! add a new initialization level to
   static tDiaResult addInitializationLevel ( InitializationLevel& level );// { return DIA_FAILED; }
   //! add a new initialization level to
   static tDiaResult addInitializationLevel ( InitializationLevel* pLevel );// { return DIA_FAILED; }

   //! add a new initialization level to
   static void clearInitializationLevels ( void );

   dia_enInitLevel getLevelID ( void ) const { return mLevelID; }

protected:
   //! deprecated constructor without implementation
   InitializationLevel ( void );

   //! checks whether this key is equal to the specified key
   bool equal ( const InitializationLevel& key );
   //! checks whether this key is less than the specified key
   bool less  ( const InitializationLevel& key );

protected:
   //! initialization sequence
   static std::list<InitializationLevel*> mLevelSequence;
   //! level identifier
   dia_enInitLevel mLevelID;
};

}

#endif /* __INCLUDED_DIA_INITIALIZATION_LEVEL__ */
