/*
 * dia_Factory.cpp
 *
 *  Created on: 21.05.2012
 *      Author: gib2hi
 */

#include <string.h>

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER__
#include <common/framework/sysadapters/dia_SystemAdapter.h>
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifdef __STARTUP_REFACTORING_ENABLE__

#ifndef __INCLUDED_DIA_INITIALIZATION_LEVEL__
#include <common/framework/application/dia_InitializationLevel.h>
#endif

#endif

using namespace dia;

dia_Factory* dia_Factory::mpInstance = NULL;

//dia_Lock dia_Factory::mSyncObj("dia_Factory_LK");


#ifndef __DIA_UNIT_TESTING__

//------------------------------------------------------------------------------

dia_Factory*
getInstanceOfFactory (void )
{
//   if ( dia_Factory::lockFactory() != DIA_SUCCESS ) return 0;
   return dia_Factory::getInstance();
}

//------------------------------------------------------------------------------

void
releaseInstanceOfFactory (void )
{
  return dia_Factory::deleteInstance();
}

#endif

//------------------------------------------------------------------------------

void
dia_Factory::deleteInstance ( void )
{
   if ( mpInstance )
   {
      OSAL_DELETE mpInstance;
      mpInstance = 0;
   }
}

//------------------------------------------------------------------------------

dia_Factory::dia_Factory ( void )
   : mSyncObj(std::string("dia_Factory_LK").c_str()),
     mActiveLevel(DIA_EN_INITLEVEL_UNKNOWN)
{}

//------------------------------------------------------------------------------

dia_Factory::~dia_Factory ( void )
{}

//------------------------------------------------------------------------------
#ifndef __DIA_UNIT_TESTING__

dia_SystemAdapter*
dia_Factory::createSystemAdapter ( tCString name, tU16 clientAppID ) const
{
   return dia_SystemAdapter::create(name,clientAppID);
}

#endif
//------------------------------------------------------------------------------
#ifndef __DIA_UNIT_TESTING__

dia_SystemAdapterServicePlugin*
dia_Factory::createSystemAdapterServicePlugin (
      tCString name,        // name used to create name for lock and condvar object
      tU16 srvID,           // service of the client we are using
      tU16 srvMajVersion,   // major version number of the service
      tU16 srvMinVersion,   // minor version number of the service
      dia_SystemAdapter* adapter ) const
{
   dia_SystemAdapterServicePlugin* pPlugin = 0;

   if ( adapter )
   {
      pPlugin = OSAL_NEW dia_SystemAdapterServicePlugin(name,srvID,srvMajVersion,srvMinVersion,*adapter);
      if ( pPlugin )
      {
         adapter->addServicePlugin(*pPlugin);
      }
   }
   return pPlugin;
}

#endif
//------------------------------------------------------------------------------

#ifndef __DIA_UNIT_TESTING__

dia_SystemAdapterServicePluginDiaglib*
dia_Factory::createSystemAdapterServicePluginDiaglib (
      tCString name,        // name used to create name for lock and condvar object
      tU16 srvMajVersion,   // major version number of the service
      tU16 srvMinVersion,   // minor version number of the service
      dia_SystemAdapter* adapter ) const
{
   dia_SystemAdapterServicePluginDiaglib* pPlugin = 0;

   if ( adapter )
   {
      pPlugin = OSAL_NEW dia_SystemAdapterServicePluginDiaglib(name,srvMajVersion,srvMinVersion,*adapter);
      if ( pPlugin )
      {
         adapter->addServicePlugin(*pPlugin);
      }
   }
   return pPlugin;
}

#endif

//-----------------------------------------------------------------------------

#ifndef __DIA_UNIT_TESTING__

tDiaResult
dia_Factory::deleteSystemAdapters ( void )
{
   // this method is deprecated
   return DIA_FAILED;
}

#endif

//------------------------------------------------------------------------------

#ifndef __DIA_UNIT_TESTING__

tDiaResult
dia_Factory::unregisterInterfaces ( void )
{
   return DIA_SUCCESS; //(dia_SystemAdapterFacade::bUnregisterInterfaces()) ? DIA_SUCCESS : DIA_FAILED;
}

#endif

//------------------------------------------------------------------------------

dia_Session*
dia_Factory::makeSession ( tU8 sessionID, dia_EngineServer& rEngine )
{
   dia_tclFnctTrace oTrace("dia_Factory::makeSession");
   return OSAL_NEW dia_Session(sessionID,rEngine);
}

//------------------------------------------------------------------------------

tU8
dia_Factory::makeNRC ( tDiaResult retCode )
{
   dia_tclFnctTrace oTrace("dia_Factory::makeNRC");

   tU8 nrc = DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT;

   std::map<tDiaResult,dia_NRCConfig>::iterator iter = mNRCRepository.find(retCode);

   if ( iter != mNRCRepository.end() )
   {
      dia_NRCConfig nrcData = iter->second;
     nrc = nrcData.mNRC;
   }

   DIA_TR_ERR("dia_Factory::makeNRC,  Returning NRC 0x%02X for retCode: 0x%08X", nrc, retCode);
   return nrc;
}


//----------------------------------------------------------------------------------------

tDiaResult
dia_Factory::loadNRCMapping ( const dia_NRCConfig& mapping )
{
   dia_tclFnctTrace oTrace("dia_Factory::loadNRCMapping");
   mNRCRepository[mapping.mErrCode] = mapping;
   return DIA_SUCCESS;
}

tDiaResult
dia_Factory::loadNRCMappings ( const dia_NRCConfig mapping[], tU16 numOfItems )
{
   dia_tclFnctTrace oTrace("dia_Factory::loadNRCMappings");

   tDiaResult retCode = DIA_FAILED;

   if ( mapping )
   {
      for ( tU16 i=0; i<numOfItems; ++i )
      {
       mNRCRepository[mapping[i].mErrCode] = mapping[i];
      }
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

void
dia_Factory::clearNRCmappings (void)
{
   dia_tclFnctTrace oTrace("dia_Factory::clearNRCmappings");

   mNRCRepository.clear();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Factory::setupFactoryPlugins ( dia_enInitLevel level )
{
   tDiaResult retCode = DIA_SUCCESS;

   dia_LockScope mScopeLock(mSyncObj);

   std::list<dia_FactoryPlugin*>::iterator iter = mSubFactoryRep.begin();
   for ( ; iter != mSubFactoryRep.end(); iter++ )
   {
      dia_FactoryPlugin* pSubFactory = (*iter);
      if ( pSubFactory )
      {
         if ( pSubFactory->setup(level) != DIA_SUCCESS )
         {
            DIA_ASSERT_ALWAYS();
            retCode = DIA_FAILED;
            break;
         }
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Factory::teardownFactoryPlugins ( dia_enInitLevel level )
{
   tDiaResult retCode = DIA_SUCCESS;

   dia_LockScope mScopeLock(mSyncObj);

   // reverse_iterator was not working properly, so we use reverse() to change order
   if ( mSubFactoryRep.size() )
   {
      mSubFactoryRep.reverse();

      std::list<dia_FactoryPlugin*>::iterator iter = mSubFactoryRep.begin();
      for ( ; iter != mSubFactoryRep.end(); iter++ )
      {
         dia_FactoryPlugin* pSubFactory = (*iter);
         if ( pSubFactory )
         {
            if ( pSubFactory->tearDown(level) != DIA_SUCCESS )
            {
               DIA_ASSERT_ALWAYS();
               retCode = DIA_FAILED;
               break;
            }
         }
      }
      mSubFactoryRep.reverse();
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Factory::addFactoryPlugin ( dia_FactoryPlugin* pPlugin )
{
   dia_tclFnctTrace trc("dia_Factory::addFactoryPlugin");

   if ( !pPlugin ) return DIA_E_INVALID_POINTER;

   tDiaResult retCode = DIA_FAILED;

   bool found = false;

   std::list<dia_FactoryPlugin*>::iterator iter = mSubFactoryRep.begin();
   for ( ; iter != mSubFactoryRep.end(); iter++ )
   {
      if ( (*iter) && ((*iter)->getUID() == pPlugin->getUID()) )
      {
         found = true;
         break;
      }
   }

   if ( !found )
   {
      mSubFactoryRep.push_back(pPlugin);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Factory::queryFactoryPlugin ( dia_UID uid, dia_FactoryPlugin** ppPlugin )
{
   dia_tclFnctTrace oTrace("dia_Factory::queryFactoryPlugin(dia_UID,dia_FactoryPlugin**)");

   tDiaResult retCode = DIA_FAILED;

   if ( ppPlugin )
   {
      *ppPlugin = 0;

      std::list<dia_FactoryPlugin*>::iterator iter = mSubFactoryRep.begin();

      for ( ; iter != mSubFactoryRep.end(); iter++ )
      {
         dia_FactoryPlugin* pPlugin = (*iter);
         if ( pPlugin && (pPlugin->getUID() == uid) )
         {
            *ppPlugin = pPlugin;
            retCode = DIA_SUCCESS;
            break;
         }
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Factory::queryFactoryPlugin ( tCString name, dia_FactoryPlugin** ppPlugin )
{
   dia_tclFnctTrace oTrace("dia_Factory::queryFactoryPlugin(tCString,dia_FactoryPlugin**)");

   return queryFactoryPlugin(dia_getHashCodeFromString(name),ppPlugin);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Factory::requestInitializationLevel ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_Factory::requestInitializationLevel(dia_enInitLevel)");

   tDiaResult retCode = DIA_SUCCESS;

   if ( mActiveLevel < level )
   {
	  dia_LockScope mScopeLock(mSyncObj);
#ifdef __STARTUP_REFACTORING_ENABLE__
      const std::list<InitializationLevel*>& initLevels = InitializationLevel::getInitializationLevels();
      std::list<InitializationLevel*>::const_iterator levelIter = initLevels.begin();
      bool done = false;
      for ( ; (levelIter != initLevels.end()) && (!done); ++levelIter )
      {
         retCode = setup((dia_enInitLevel) (*levelIter)->getUID());
         if ( retCode != DIA_SUCCESS )
         {
            DIA_TR_INF("##### INITIALIZATION OF LEVEL %d FAILED #####",(((tS16) level)-1));
            break;
         }

         if ( (*levelIter)->getUID() == level )
         {
            done = true;
         }
      }
#else
      for ( tU16 i=DIA_EN_INITLEVEL_0; i<=level; i++ )
      {
         retCode = setup((dia_enInitLevel) i);
         if ( retCode != DIA_SUCCESS )
         {
            DIA_TR_INF("##### INITIALIZATION OF LEVEL %d FAILED #####",(((tS16) level)-1));
            break;
         }
      }
#endif
   }

   return retCode;
}

#ifdef __STARTUP_REFACTORING_ENABLE__
tDiaResult
dia_Factory::makeInitializationLevels(void)
{
	ScopeTrace oTrace("dia_Factory::makeInitializationLevels");
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_0", DIA_EN_INITLEVEL_0));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_1", DIA_EN_INITLEVEL_1));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_2", DIA_EN_INITLEVEL_2));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_3", DIA_EN_INITLEVEL_3));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_4", DIA_EN_INITLEVEL_4));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_5", DIA_EN_INITLEVEL_5));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_6", DIA_EN_INITLEVEL_6));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_7", DIA_EN_INITLEVEL_7));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_8", DIA_EN_INITLEVEL_8));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_9", DIA_EN_INITLEVEL_9));
	InitializationLevel::addInitializationLevel(new InitializationLevel("DIA_EN_INITLEVEL_10", DIA_EN_INITLEVEL_10));
	return DIA_SUCCESS;
}
#endif