/************************************************************************
* FILE:         dia_EventThread.cpp
* PROJECT:      Fc_Diagnosis
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Class to starts the fc_diagnosis multi-purpose event waiting thread
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 02.03.15  | NBS3KOR            | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_MAIN__
#include "../../depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_EVENT_THREAD__
#include "common/framework/application/dia_EventThread.h"
#endif

// application control
//#ifndef __INCLUDED_DIA_APPCONTROLLER__
//#include "common/framework/application/dia_AppController.h"
//#endif

#ifndef __INCLUDED_DIA_THREAD_MONITOR__
#include "common/framework/application/dia_ThreadMonitor.h"
#endif

#define DIA_FEATURE_ACTIVATION_SYSSET

//#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
//#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include <common/framework/sysset/dia_common_sysset.h>
#endif

#ifdef DIA_FEATURE_ACTIVATION_SYSSET
#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif
#endif

//#ifndef __INCLUDED_DIA_DEFSET_SETTODEFAULT__
//#include "common/framework/sysset/dia_tclDefset_SetToDefault.h"
//#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include "common/framework/test/dia_TestController.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include <common/framework/datalogger/dia_DataLogger.h>
#endif

#include <common/framework/application/dia_ApplicationLock.h>

tCString dia_EventThread::strThreadName = "EVENT_WAIT";
OSAL_tSemHandle dia_EventThread::m_hEvent = OSAL_C_INVALID_HANDLE;


DIA_IMPL_SINGLETON_WITH_SETUP_AND_TEARDOWN(dia_EventThread)

//#ifndef __DIA_UNIT_TESTING__

dia_EventThread*
getInstanceOfdiaEventThread ( void )
{
   return dia_EventThread::getInstance();
}

void
releaseInstanceOfdiaEventThread ( void )
{
   dia_EventThread::deleteInstance();
}
//#endif

//-----------------------------------------------------------------------------

dia_EventThread::dia_EventThread ( void )
   : dia_ActiveObject(strThreadName,DIA_PROP_EVENT_WAIT_THREAD_PRIO,DIA_PROP_EVENT_WAIT_THREAD_STACK_SIZE)
{
   dia_tclFnctTrace oTrace("dia_EventThread::dia_EventThread()");
}

//------------------------------------------------------------------------------

tDiaResult
dia_EventThread::setup ( void )
{
   dia_tclFnctTrace oTrace("dia_EventThread::setup()");

   // create an Event for the event thread
   DIA_TR_INF("diagnostics_tclApp::bOnInit - Create Event for worker thread");
   tS32 s32Result = OSAL_s32EventCreate(DIA_EVENT_NAME, &m_hEvent);
   if(OSAL_ERROR == s32Result)
   {
       m_hEvent = OSAL_C_INVALID_HANDLE;
       DIA_TR_INF("diagnostics_tclApp::bOnInit - Event creation FAILED!");
       NORMAL_M_ASSERT(OSAL_ERROR != s32Result);
   }

   startThread();

   DIA_TR_INF("dia_EventThread::setup() returned DIA_SUCCESS");
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

dia_EventThread::~dia_EventThread ( void )
{
   _BP_TRY_BEGIN
   {
      (void)tearDown();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_EventThread::~dia_EventThread !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EventThread::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_EventThread::tearDown()");

   //terminate thread
   terminateThread();

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_EventThread::vThreadEntrypointObject ( void )
{
   DIA_TR_INF( "---> Entering  dia_EventThread::vThreadEntrypointObject");

   OSAL_tEventMask hEvRequest = 0;
   tU32 u32Mask = DIA_EVENT_MASK;
   tBool bIsDone = FALSE;

   diagnostics_tclApp* pApp = diagnostics_tclApp::getInstance();
   if ( !pApp )
   {
      DIA_TR_ERR("dia_EventThread::vWaitThread - App Pointer invalid!");
      return;
   }

   while ( !bIsDone )
   {
      NORMAL_M_ASSERT(OSAL_C_INVALID_HANDLE != m_hEvent);

      tS32 s32result = OSAL_s32EventWait (
            m_hEvent,
            u32Mask,
            OSAL_EN_EVENTMASK_OR,
            OSAL_C_TIMEOUT_FOREVER,
            &hEvRequest
      );
#if !defined(VARIANT_S_FTR_DONOTUSE_APPLICATION_LOCK) && !defined(__DIA_UNIT_TESTING__)
      LockScope rLock((getInstanceOfApplicationLock()->getAppLock()));
#endif
      if( OSAL_OK != s32result )
      {
        DIA_TR_ERR("dia_EventThread::vWaitThread - EventWait returned NotOk!");
         break;
      }

      // clear events
      if ( m_hEvent != OSAL_C_INVALID_HANDLE )
      {
         DIA_TR_INF("dia_EventThread::vWaitThread - Event Received: 0x%x", (tU32)hEvRequest);

         if ( OSAL_s32EventPost(m_hEvent, ~hEvRequest, OSAL_EN_EVENTMASK_AND) != OSAL_OK)
         {
            DIA_ASSERT_ALWAYS();
         }

#ifdef DIA_FEATURE_ACTIVATION_SYSSET
         // EVENT: Incoming request for SystemSet Event Queue
         // ==============================================================================
         if (hEvRequest & DIA_EVENT_SYSSET_FSM_EVENTS )
         {
            DIA_TR_INF("EVENT: Incoming request for SystemSet Event Queue");
            getInstanceOfSystemSettingsManager()->onProcessEvents();
         }
#endif

//#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAG_VAG
//         if ( hEvRequest & DIA_EVENT_DEFSET_DONE )
//         {
//           DIA_TR_INF("dia_EventThread::vWaitThread - DefSet done");
//            dia_tclDefset_SetToDefault::deleteInstance();
//         }
//#endif

//         if ( hEvRequest & DIA_EVENT_DEFSET_TIMEOUT )
//         {
//           DIA_TR_INF("dia_EventThread::vWaitThread - DefSet timeout");
//            dia_tclDefset_SetToDefault* poDefset = NULL;
//            if ( dia_tclDefset_SetToDefault::dia_tclDefset_GetInterface(&poDefset) )
//            {
//               if ( poDefset != NULL )
//               {
//                  poDefset->vEventTimeout();
//               }
//            }
//         }

         if ( hEvRequest & DIA_EVENT_EOL_UPDATE_FINISH )
         {
            dia_TestController* pTestController = getInstanceOfTestController();
            if ( pTestController )
            {
               DIA_TR_INF("--- dia_EventThread::vWaitThread => Running test for EOL Update Finish");
               (tVoid) pTestController->runTests(DIA_EN_TESTCONDITION_EOL_UPDATE_FINISH);
            }
            else
            {
               DIA_TR_ERR("!!! dia_EventThread::vWaitThread => ERROR: pTestController == NULL");
            }
         }

         if ( hEvRequest & DIA_EVENT_SHUTDOWN_THREAD )
         {
           DIA_TR_INF("dia_EventThread::vWaitThread - Shutdown thread");
            bIsDone = TRUE;
         }

         if ( hEvRequest & DIA_EVENT_START_RUNIN )
         {
            dia_TestController* pTestController = getInstanceOfTestController();
            if ( pTestController )
            {
               DIA_TR_INF("--- dia_EventThread::vWaitThread => Starting Run-In ...");
               (void) pTestController->runTests(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_RUNIN);
            }
            else
            {
               DIA_TR_ERR("!!! dia_EventThread::vWaitThread => ERROR: pTestController == NULL");
            }
         }

         if ( hEvRequest & DIA_EVENT_START_PDX_FLASHING )
         {
            dia_TestController* pTestController = getInstanceOfTestController();
            if ( pTestController )
            {
               DIA_TR_INF("--- dia_EventThread::vWaitThread => Starting PDXFlashingTest ...");
               (void) pTestController->runTests(DIA_EN_TESTCONDITION_STARTUP_DIAGNOSIS_PDX_FLASHING);
            }
            else
            {
               DIA_TR_ERR("!!! dia_EventThread::vWaitThread => ERROR: pTestController == NULL");
            }
         }

         if( hEvRequest & DIA_EVENT_LOG_DATA)
         {
            dia_DataLogger* pDataLogger = dia_DataLogger::getInstance();
            if(pDataLogger)
            {
               pDataLogger->sample();
            }
         }

      } // if (m_hEvent != OSAL_C_INVALID_HANDLE)
   } // while (TRUE)

   DIA_TR_INF("<-- dia_EventThread::vWaitThread");
   // Exit this thread of execution
   OSAL_vThreadExit();
}


tBool
dia_EventThread::bPostEvent ( tU32 u32Event ) const
{
   tBool bRetCode = FALSE;

   if ( m_hEvent != OSAL_C_INVALID_HANDLE )
   {
      tS32 s32Result = OSAL_s32EventPost(m_hEvent,u32Event,OSAL_EN_EVENTMASK_OR);
      NORMAL_M_ASSERT(OSAL_ERROR != s32Result);
      DIA_TR_INF("dia_EventThread::bPostEvent - Posted event to worker thread: 0x%x", u32Event);
      bRetCode = TRUE;
   }
   else
   {
     DIA_TR_ERR("dia_EventThread::bPostEvent - Event posting failed. Event: 0x%x", u32Event);
     DIA_ASSERT_ALWAYS();
   }

   return bRetCode;
}

//----------------------------------------------------------------------------

