/**
 * \file      dia_EventLogger.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Mar 8, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */


#ifndef __INCLUDED_DIA_EVENT_LOGGER__
#include "common/framework/application/dia_EventLogger.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_EVENT_LOG__
#include "common/framework/application/dia_EventLog.h"
#endif

#include <climits>

#define DIA_PROP_CM_MAX_NUM_ENTRIES_LENGTH 2

DIA_IMPL_SINGLETON(dia_EventLogger)

#ifndef __DIA_UNIT_TESTING__

dia_EventLogger*
getInstanceOfEventLogger ( void )
{
   DIA_TR_INF("getInstanceOfEventLogger() not for UT");
   return dia_EventLogger::getInstance();
}

void
releaseInstanceOfEventLogger ( void )
{
   DIA_TR_INF("releaseInstanceOfEventLogger() not for UT");
   return dia_EventLogger::deleteInstance();
}
#endif

dia_EventLogger::dia_EventLogger(void):MaxNumberOfElem(200)
{
   DIA_TR_INF("dia_EventLogger::dia_EventLogger()");


}

dia_EventLogger::~dia_EventLogger ( void )
{
   DIA_TR_INF("dia_EventLogger::~dia_EventLogger()");

   _BP_TRY_BEGIN
   {
      destroy();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_EventLogger::~dia_EventLogger !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

void
dia_EventLogger::SetMaxSizeOfList(size_t newSize)
{
   if (newSize > DIA_EVENT_LOGGER_LIST_LIMIT)
   {
      DIA_TR_INF("dia_EventLogger::SetMaxSizeOfList New size = %zu too big. Limit = %u is hardcoded ", newSize, DIA_EVENT_LOGGER_LIST_LIMIT);
   }

   if (MaxNumberOfElem==newSize)
   {
      DIA_TR_INF("dia_EventLogger::SetMaxSizeOfList New size is equal to the old size = %zu, no change.", MaxNumberOfElem);
   }
   else if (MaxNumberOfElem<newSize)
   {
      DIA_TR_INF("dia_EventLogger::SetMaxSizeOfList New size = %zu is greater than old size = %zu. Size changed.", newSize, MaxNumberOfElem);
      MaxNumberOfElem = newSize;
   }
   else if (MaxNumberOfElem>newSize)
   {
      size_t currentSize = mEventRep.size();

      DIA_TR_INF("dia_EventLogger::SetMaxSizeOfList New size = %zu is less than old size = %zu. Current size is %zu.", newSize, MaxNumberOfElem, currentSize);

      if (currentSize>newSize)
      {
         size_t diff = (currentSize - newSize);
         DIA_TR_INF("dia_EventLogger::SetMaxSizeOfList Deleting %zu elements....", diff );

         for (size_t i=0; i<diff; i++)
         {
            dia_EventLog* pEvent = mEventRep.back();
            OSAL_DELETE pEvent;
            mEventRep.pop_back();
         }

         DIA_TR_INF("dia_EventLogger::SetMaxSizeOfList Deleted %zu elements. New size is %zu", diff, mEventRep.size() );
      }
      else
      {
         DIA_TR_INF("dia_EventLogger::SetMaxSizeOfList Size changed to less value.");
         MaxNumberOfElem = newSize;
      }
   }
}

size_t
dia_EventLogger::readMaxSizeOfList(void) const
{
   // retrieve size of property
   tU32 maxNumberEntries = 0;

   tDiaResult retCode = dia_getProperty(DIA_PROP_CM_EVENT_LOGGER_MAX_ENTRIES, maxNumberEntries);

   if ( (DIA_SUCCESS == retCode) && (0!=maxNumberEntries) )
   {
      DIA_TR_INF("dia_EventLogger::readMaxSizeOfList %d.", maxNumberEntries);
   }
   else
   {
      /* default value */
      maxNumberEntries = 200;
      DIA_TR_INF("Maximal number of entries cannot be read, default value is %d.", maxNumberEntries);
   }

   return maxNumberEntries;
}

tU16
dia_EventLogger::numberOfEvents ( void ) const
{
   return (tU16) mEventRep.size();
}

tU16
dia_EventLogger::convertCharArrayToInt(const tS8* convertedStr)
{
   DIA_TR_INF("dia_EventLogger::convertCharArrayToInt()");

   tU16 retVal = 0;
   bool nullFound = false;
   bool notDigitFound = false;
   tU8 maxStrLen = 5; /* because max value is "65535" */

   for (tU8 i=0; i<maxStrLen; i++)
   {
      if (convertedStr[i]=='\0')
      {
         nullFound = true;
         break;
      }

      if (0!=isdigit(convertedStr[i]))
      {
         notDigitFound = true;
         break;
      }
   }

   if ((false==nullFound) || (true==notDigitFound))
   {
      /* do nothing, return 0 */
   }
   else
   {
      tU32 tempVal = static_cast<tU32>(atoi(reinterpret_cast<const char*>(convertedStr)));

      if (tempVal<=USHRT_MAX)
      {
         retVal = static_cast<tU16>(tempVal);
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_EventLogger::addEvent(tU16 errCode, const char* fileName, tU32 lineNumber32bit )
{
   if (NULL==fileName)
   {
      DIA_TR_ERR("dia_EventLogger::addEvent(errCode=0x%04X, lineNumber32bit=%d) File name not available", errCode, lineNumber32bit);
      return;
   }

   char* pFileName = const_cast<char*>(strrchr( fileName, '/'));
   if (NULL==pFileName)
   {
      /* '/' not found */
      pFileName = const_cast<char*>(fileName);
   }
   else
   {
      pFileName++;
   }

   DIA_TR_INF("dia_EventLogger::addEvent(errCode=0x%04X, fileName=%s, lineNumber32bit=%d)", errCode, pFileName, lineNumber32bit);

   /* get timestamp */
   const tS8* tStamp = (const tS8*)"2000.01.01_00:00:00";
   tU16 lineNumber16bit = 0;

   if (lineNumber32bit<=USHRT_MAX)
   {
      lineNumber16bit = static_cast<tU16>(lineNumber32bit);
   }
   else
   {
      /* do nothing, take 0 instead */
   }

   dia_EventLog* pEvn = OSAL_NEW dia_EventLog( tStamp, pFileName, errCode, lineNumber16bit );

   if (NULL!=pEvn)
   {
      if (mEventRep.size()==MaxNumberOfElem)
      {
         DIA_TR_INF("dia_EventLogger::addEvent(tU16, tU32) MaxNumberOfElem=%zu mEventRep.size=%zu", MaxNumberOfElem, mEventRep.size());
         dia_EventLog* pEvent = mEventRep.back();
         OSAL_DELETE pEvent;
         mEventRep.pop_back();
      }

      mEventRep.push_front(pEvn);

      DIA_TR_INF("dia_EventLogger::addEvent(tU16, tU32) Obj=0x%p added. New size of list is %zu.", pEvn, mEventRep.size());
   }
   else
   {
      DIA_TR_ERR("dia_EventLogger::addEvent(tU16, tU32) Object cannot be created.");
   }
}//lint !e429: custodial pointer is freed when the list is full or by destroy function.

//-----------------------------------------------------------------------------

void
dia_EventLogger::addEvent(tU16 errCode, const char* fileName, const tS8* lineNumberStr )
{
   if (NULL==fileName)
   {
      DIA_TR_ERR("dia_EventLogger::addEvent(errCode=0x%04X) File name not available", errCode);
      return;
   }

   char* pFileName = const_cast<char*>(strrchr( fileName, '/'));
   if (NULL==pFileName)
   {
      /* '/' not found */
      pFileName = const_cast<char*>(fileName);
   }
   else
   {
      pFileName++;
   }

   DIA_TR_INF("dia_EventLogger::addEvent(errCode=0x%04X, fileName=%s, lineNumberStr=%s)", errCode, pFileName, lineNumberStr);

   /* get timestamp */
   const tS8* tStamp = (const tS8*)"2000.01.01_00:00:00";

   tU16 lineNumber = convertCharArrayToInt(lineNumberStr);

   dia_EventLog* pEvn = OSAL_NEW dia_EventLog( tStamp, pFileName, errCode, lineNumber );

   if (NULL!=pEvn)
   {
      if (mEventRep.size()==MaxNumberOfElem)
      {
         DIA_TR_INF("dia_EventLogger::addEvent(tU16, const char*) MaxNumberOfElem=%zu mEventRep.size=%zu", MaxNumberOfElem, mEventRep.size());
         dia_EventLog* pEvent = mEventRep.back();
         OSAL_DELETE pEvent;
         mEventRep.pop_back();
      }

      mEventRep.push_front(pEvn);
      DIA_TR_INF("dia_EventLogger::addEvent(tU16, const char*) Obj=0x%p added. New size of list is %zu.", pEvn, mEventRep.size());
   }
   else
   {
      DIA_TR_ERR("dia_EventLogger::addEvent(tU16, const char*) Object cannot be created.");
   }
}//lint !e429: custodial pointer is freed when the list is full or by destroy function.

//-----------------------------------------------------------------------------

void
dia_EventLogger::destroy ( void )
{
   DIA_TR_INF("dia_EventLogger::destroy()");

   std::list<dia_EventLog*>::iterator listIter = mEventRep.begin();
   for ( ; listIter != mEventRep.end(); listIter++ )
   {
      DIA_TR_INF("dia_EventLogger::destroy() delete obj=0x%p", (*listIter));
      OSAL_DELETE (*listIter);
   }

   DIA_TR_INF("dia_EventLogger::destroy() Run clear()");
   mEventRep.clear();
}


//-----------------------------------------------------------------------------

void
dia_EventLogger::DumpEvents ( tU32 reqNumberItems )
{
   DIA_TR_INF("===================================================== dia_EventLogger::DumpEvents() START");

   std::list<dia_EventLog*>::iterator listIter = mEventRep.begin();
   for ( tU32 i=0; (listIter != mEventRep.end()) && i<reqNumberItems; listIter++, i++ )
   {
      (*listIter)->Dump();
   }

   DIA_TR_INF("===================================================== dia_EventLogger::DumpEvents() END");
}

tU16
dia_EventLogger::GetErrorCode ( tU32 numberItemFromBegin )
{
   tU16 retVal = 0;
   DIA_TR_INF("dia_EventLogger::GetErrorCode numberItemFromBegin=%d", numberItemFromBegin);

   std::list<dia_EventLog*>::iterator listIter = mEventRep.begin();
   for ( tU32 i=0; (listIter != mEventRep.end()) && i<numberItemFromBegin; listIter++, i++ )
   {
      ;
   }

   if (listIter != mEventRep.end())
   {
      retVal = (*listIter)->GetErrorCode();
   }
   else
   {
      /* incorrect value */
      retVal = 0;
   }

   DIA_TR_INF("dia_EventLogger::GetErrorCode retVal=0x%04X", retVal);

   return retVal;
}
