/*
 * dia_CondVar.h
 *
 *  Created on: 22.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_CONDVAR__
#define __INCLUDED_DIA_CONDVAR__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_CONDVAR_AS_PTHREAD_CONDVAR
#include <unistd.h>
#include <pthread.h>
#endif


#define DIA_C_CONDVAR_EVENT_BROADCAST     ((tU32) 0x00000001)
#define DIA_C_CONDVAR_EVENT_01            ((tU32) 0x00000002)
#define DIA_C_CONDVAR_EVENT_02            ((tU32) 0x00000004)
#define DIA_C_CONDVAR_EVENT_03            ((tU32) 0x00000008)
#define DIA_C_CONDVAR_EVENT_04            ((tU32) 0x00000010)
#define DIA_C_CONDVAR_EVENT_05            ((tU32) 0x00000020)

#define DIA_C_CONDVAR_TIMEOUT_FOREVER     ((tU32) 0xFFFFFFFF)

class dia_CondVar
{
public:
   //! class constructor
   dia_CondVar ( const tChar* pName );
   //! class destructor
   virtual ~dia_CondVar ( void );

   //! if the expression is FALSE wait until condition is signaled or timed out
   tDiaResult wait ( tU32 condMask, tU32 timeout=DIA_C_CONDVAR_TIMEOUT_FOREVER );
   //! signal the specified condition
   tDiaResult signal ( tU32 condMask, tBool state );
   //! broadcast an event to unblock the condition variable
#ifndef VARIANT_S_FTR_ENABLE_CONDVAR_AS_PTHREAD_CONDVAR
   tDiaResult broadcast ( void ) const;
   tDiaResult resetBroadcast ( void );
#else
   tDiaResult broadcast ( void );
   tDiaResult resetBroadcast ( void );
#endif
   //! check if the given Signal is set
   tBool checkSignal ( tU32 condMask ) const;

protected:
   //! default class constructor
   dia_CondVar ( void );

   //! unique name of the condition variable (used for the event)
   std::string mName;

   //! event mask
   tU32 mEventMask;

#ifndef VARIANT_S_FTR_ENABLE_CONDVAR_AS_PTHREAD_CONDVAR
   //! event to wait for
   OSAL_tEventHandle mEvent;
#else
   tU32 mWaitMask;
   pthread_cond_t mCondVar;
   pthread_mutexattr_t  mAttr;
   pthread_mutex_t      mMutex;
#endif
};

#endif /* __INCLUDED_DIA_CONDVAR__ */
