/**
 * \file      dia_CommandControllerPluginRunlevel.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 30, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER__
#include <common/framework/application/dia_CommandController.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN_RUNLEVEL__
#include <common/framework/application/dia_CommandControllerPluginRunlevel.h>
#endif

#ifndef __INCLUDED_DIA_PREDICATE_RUNLEVEL__
#include <common/framework/application/dia_PredicateRunlevel.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND__
#include <common/framework/application/dia_Command.h>
#endif

#include <string.h>
using namespace dia;

//-----------------------------------------------------------------------------

dia_CommandControllerPluginRunlevel::dia_CommandControllerPluginRunlevel ( void )
   : dia_CommandControllerPlugin(DIA_EN_CMD_CTRL_PLUGIN_TYPE_RUNLEVEL)
{}

//-----------------------------------------------------------------------------

dia_CommandControllerPluginRunlevel::~dia_CommandControllerPluginRunlevel ( void )
{}

//-----------------------------------------------------------------------------

void
dia_CommandControllerPluginRunlevel::vOnRunLevelChanged ( dia_enRunlevel newLevel, dia_enRunlevel oldLevel )
{
   ScopeTrace trc("dia_CommandControllerPluginRunlevel::vOnRunLevelChanged()");

   std::vector<tU32> args;
   args.push_back(newLevel);
   args.push_back(oldLevel);
   
   std::string str = dia_composeStlString("%s_%d",dia_PredicateRunlevel::getClassName(),(int) newLevel);//Coverity Fix(CID:117899)
   if ( !str.empty() )
   {
      dia_UID uid = dia_getHashCodeFromString(str);
      getInstanceOfCommandController()->update(uid,args);
   }
}

