/**
 * \file      dia_CommandControllerPluginOpMode.h
 *
 * \brief     Listens to changes in Opmode
 *
 *
 * \copyright Robert Bosch Car Multimedia 2018
 */


#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN_OPMODE__
#define __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN_OPMODE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN__
#include <common/framework/application/dia_CommandControllerPlugin.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_OPMODE_LISTENER__
#include <common/interfaces/dia_IOpModeListener.h>
#endif

namespace dia {

class CommandControllerPluginOpMode
   : public dia_CommandControllerPlugin,
     public dia_IOpModeListenerImpl
{

public:
   //! class constructor
   CommandControllerPluginOpMode ( void );
   //! class destructor
   virtual ~CommandControllerPluginOpMode ( void );

   //! overloaded method from dia_IOpModeListener
   virtual void vOnOpMode ( tU8 newOpMode, tU8 oldOpMode );
};

}

#endif /* __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN_OPMODE__ */
