/**
 * \file      dia_CommandControllerPluginOpMode.cpp
 *
 * \brief     Listens to Opmode changes
 *
 *
 * \copyright Robert Bosch Car Multimedia 2018
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER__
#include <common/framework/application/dia_CommandController.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN_OPMODE__
#include <common/framework/application/dia_CommandControllerPluginOpMode.h>
#endif

#ifndef __INCLUDED_DIA_PREDICATE_ALDSTATUS__
#include <common/framework/application/dia_PredicateOpMode.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND__
#include <common/framework/application/dia_Command.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif


namespace dia {

//-----------------------------------------------------------------------------

CommandControllerPluginOpMode::CommandControllerPluginOpMode ( void )
   : dia_CommandControllerPlugin(DIA_EN_CMD_CTRL_PLUGIN_TYPE_OPMODE)
{
   (void) setSysAdapterListener<dia_IOpModeListener>(this);
}

//-----------------------------------------------------------------------------

CommandControllerPluginOpMode::~CommandControllerPluginOpMode ( void )
{
   (void) unsetSysAdapterListener<dia_IOpModeListener>(this);
}

//-----------------------------------------------------------------------------

void
CommandControllerPluginOpMode::vOnOpMode ( tU8 newOpMode, tU8 oldOpMode )
{
   ScopeTrace trc("CommandControllerPluginOpMode::vOnOpMode()");

   std::vector<tU32> args;
   args.push_back(newOpMode);
   args.push_back(oldOpMode);

   std::string str = dia_composeStlString("%s",dia::PredicateOpMode::getClassName());
   UID uid = dia_getHashCodeFromString(str);
   getInstanceOfCommandController()->update(uid, args);
}

}

