/**
 * \file      dia_CommandControllerPluginALDStatus.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \copyright Robert Bosch Car Multimedia 2017
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER__
#include <common/framework/application/dia_CommandController.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN_ALDSTATUS__
#include <common/framework/application/dia_CommandControllerPluginALDStatus.h>
#endif

#ifndef __INCLUDED_DIA_PREDICATE_ALDSTATUS__
#include <common/framework/application/dia_PredicateALDStatus.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND__
#include <common/framework/application/dia_Command.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif


namespace dia {

//-----------------------------------------------------------------------------

CommandControllerPluginALDStatus::CommandControllerPluginALDStatus ( void )
   : dia_CommandControllerPlugin(DIA_EN_CMD_CTRL_PLUGIN_TYPE_ALDSTATUS)
{
   (void) setSysAdapterListener<dia_IAuthorizationLevelListener>(this);
}

//-----------------------------------------------------------------------------

CommandControllerPluginALDStatus::~CommandControllerPluginALDStatus ( void )
{
   (void) unsetSysAdapterListener<dia_IAuthorizationLevelListener>(this);
}

//-----------------------------------------------------------------------------

void
CommandControllerPluginALDStatus::vOnLevel ( tU16 levelID )
{
   ScopeTrace trc("CommandControllerPluginALDStatus::vOnLevel()");

   std::vector<tU32> args;
   args.push_back(levelID);

   std::string str = dia_composeStlString("%s",dia::PredicateALDStatus::getClassName());
   UID uid = dia_getHashCodeFromString(str);
   getInstanceOfCommandController()->update(uid, args);
}

}
