/**
 * \file      dia_CommandControllerPlugin.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 27, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN__
#define __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

enum dia_enCmdCtrlPluginType
{
   DIA_EN_CMD_CTRL_PLUGIN_TYPE_UNKNOWN = 0,
   DIA_EN_CMD_CTRL_PLUGIN_TYPE_RUNLEVEL,
   DIA_EN_CMD_CTRL_PLUGIN_TYPE_SERVICE_CCA,
   DIA_EN_CMD_CTRL_PLUGIN_TYPE_APPSTATE,
   DIA_EN_CMD_CTRL_PLUGIN_TYPE_ALDSTATUS,
   DIA_EN_CMD_CTRL_PLUGIN_TYPE_OPMODE,
   DIA_EN_CMD_CTRL_PLUGIN_TYPE_UNIT_TEST,
   DIA_EN_CMD_CTRL_PLUGIN_TYPE_COUNT
};

namespace dia {

class Command;

}

class dia_CommandControllerPlugin
{
   friend class dia_CommandController;

public:
   //!
   dia_enCmdCtrlPluginType getID ( void ) const { return mCmdCtrlPluginID; }
   //!
   virtual ~dia_CommandControllerPlugin ( void );

protected:
   //! class constructor
   dia_CommandControllerPlugin ( dia_enCmdCtrlPluginType id );
   //! deprecated default constructor without implementation
   dia_CommandControllerPlugin ( void );

protected:
   //! this method can be used by subclasses to retrieve access to the protected method of the command controller
   std::list<dia::Command*>& getCommands ( void ) const;

protected:
   dia_enCmdCtrlPluginType mCmdCtrlPluginID;
};

#endif /* __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN__ */
