/**
 * \file      dia_CmdSetDiagActivity.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    bhs1hi
 * \date      Jan 17, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_INTERFACE_SPM__
#include "common/interfaces/dia_ISpm.h"
#endif

#ifndef __INCLUDED_DIA_CMD_SET_DIAG_ACTIVITY
#include "common/framework/application/dia_CmdSetDiagActivity.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

//-----------------------------------------------------------------------------

dia_CmdSetDiagActivity::dia_CmdSetDiagActivity ( tBool activity )
    : mActivity(activity)
{
   dia_tclFnctTrace trc("dia_CmdSetDiagActivity::dia_CmdSetDiagActivity()");
}
//-----------------------------------------------------------------------------

dia_CmdSetDiagActivity::~dia_CmdSetDiagActivity ( void )
{
//   dia_tclFnctTrace trc("dia_CmdSetDiagActivity::~dia_CmdSetDiagActivity()");
}
//-----------------------------------------------------------------------------

tDiaResult
dia_CmdSetDiagActivity::execute ( void )
{
    dia_tclFnctTrace trc("dia_CmdSetDiagActivity::execute()");

    tDiaResult bRetCode = DIA_FAILED;

    dia_ISpm* pInterface = 0;
    if ( querySysAdapterInterface<dia_ISpm>(&pInterface) == DIA_SUCCESS )
    {
       if ( pInterface )
       {
          tBool mode = (mActivity) ? TRUE : FALSE;

          DIA_TR_INF( "### Requesting Diag Activity Mode %d !!!", ((mActivity) ? 1 : 0) );
          if ( pInterface->setSubState(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_ACTIVITY,mode) == DIA_SUCCESS )
          {
             DIA_TR_INF("SET DIAGNOSIS ACTIVITY SUBSTATE SUCCESSFUL !!!");
             bRetCode = DIA_SUCCESS;
          }
          else
          {
             DIA_TR_INF("FAILED TO SET DIAGNOSIS ACTIVITY SUBSTATE !!!");
          }
       }
    }
    return bRetCode;
}
//-----------------------------------------------------------------------------
