/*
 * dia_BundleContainer.cpp
 *
 *  Created on: 06.09.2017
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_BUNDLE_CONTAINER__
#include <common/framework/application/dia_BundleContainer.h>
#endif

namespace dia {

//-------------------------------------------------------------------------------------------------

BundleContainer::BundleContainer ( BundleConfiguration& bundleConfig )
   : Bundle(bundleConfig),
     mInitDone(false)
{}

//-------------------------------------------------------------------------------------------------

BundleContainer::~BundleContainer ( void )
{}

//-------------------------------------------------------------------------------------------------

tDiaResult
BundleContainer::initializeBundle ( const InitializationLevel& initLevel )
{
   tDiaResult retCode = DIA_SUCCESS;

#if __cplusplus<=201103L
   std::list<Bundle*>::iterator bundleIter = mBundles.begin();
#else
   auto bundleIter = mBundles.begin();
#endif
   for ( ; bundleIter != mBundles.end(); ++bundleIter )
   {
      if ( !(*bundleIter) ) continue;
      retCode = (*bundleIter)->initializeBundle(initLevel);
      if ( retCode != DIA_SUCCESS )
      {
         break;
      }
   }

   return retCode;
};

tDiaResult
BundleContainer::initializeBundle ( void )
{
   tDiaResult retCode = DIA_SUCCESS;
#if __cplusplus<=201103L
   std::list<Bundle*>::iterator bundleIter = mBundles.begin();
#else
   auto bundleIter = mBundles.begin();
#endif
   for ( ; bundleIter != mBundles.end(); ++bundleIter )
   {
      if ( !(*bundleIter) ) continue;
      retCode = (*bundleIter)->initializeBundle();
      if ( retCode != DIA_SUCCESS )
      {
         break;
      }
   }
   return retCode;
};
//-------------------------------------------------------------------------------------------------

void
BundleContainer::setInitialized ( bool value )
{
#if __cplusplus<=201103L
   std::list<Bundle*>::iterator bundleIter = mBundles.begin();
#else
   auto bundleIter = mBundles.begin();
#endif
   for ( ; bundleIter != mBundles.end(); ++bundleIter )
   {
      if ( !(*bundleIter) ) continue;
      (*bundleIter)->setInitialized(value);
   }
   Bundle::setInitialized(value);
};

//-------------------------------------------------------------------------------------------------

tDiaResult
BundleContainer::startBundle ( void )
{
   tDiaResult retCode = DIA_SUCCESS;

#if __cplusplus<=201103L
   std::list<Bundle*>::iterator bundleIter = mBundles.begin();
#else
   auto bundleIter = mBundles.begin();
#endif
   for ( ; bundleIter != mBundles.end(); ++bundleIter )
   {
      if ( !(*bundleIter) ) continue;
      tDiaResult retCodeBundle = (*bundleIter)->startBundle();
      if ( (retCodeBundle != DIA_SUCCESS) && (retCodeBundle != DIA_E_ALREADY_STARTED) )
      {
         retCode = retCodeBundle;
         break;
      }
   }

   if ( retCode == DIA_SUCCESS )
   {
      mIsStarted = true;
   }

   return retCode;
};

//-------------------------------------------------------------------------------------------------

tDiaResult
BundleContainer::addBundle ( Bundle& bundle )
{
   if ( bundle.getUID() == this->getUID() ) return DIA_FAILED;

   tDiaResult retCode = DIA_FAILED;

#if __cplusplus<=201103L
   std::map<UID,Bundle*>::iterator bundleIter = mBundleRep.find(bundle.getUID());
#else
   auto bundleIter = mBundleRep.find(bundle.getUID());
#endif
   if ( bundleIter == mBundleRep.end() )
   {
      mBundleRep[bundle.getUID()] = &bundle;
      mBundles.push_back(&bundle);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

}


