/*
 * dia_BundleConfiguration.h
 *
 *  Created on: 06.09.2017
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_BUNDLE_CONFIGURATION__
#define __INCLUDED_DIA_BUNDLE_CONFIGURATION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia {

//-------------------------------------------------------------------------------------------------

class BundleConfiguration
   : public ObjectWithUID
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(BundleConfiguration);

public:
   BundleConfiguration ( const std::string& configName );
   virtual ~BundleConfiguration ( void );

   bool isValid ( void ) { return mIsValid; }

protected:
   BundleConfiguration ( void );

protected:
   bool mIsValid;
};

//-------------------------------------------------------------------------------------------------

class BundleConfigurationNullObject
   : public BundleConfiguration
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(BundleConfigurationNullObject);

public:
   BundleConfigurationNullObject ( const std::string& configName ) : BundleConfiguration(configName) {}
   virtual ~BundleConfigurationNullObject ( void ) {}

protected:
   BundleConfigurationNullObject ( void );
};

}

#endif /* __INCLUDED_DIA_BUNDLE_CONFIGURATION__ */
