/*
 * dia_BundleApplication.cpp
 *
 *  Created on: 06.09.2017
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_BUNDLE_CONTAINER_APPLICATION__
#include <common/framework/application/dia_BundleApplication.h>
#endif

#ifndef __INCLUDED_DIA_INITIALIZATION_LEVEL__
#include <common/framework/application/dia_InitializationLevel.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE__
#include "common/depricated/dia_tclService.h"
#endif

#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include <common/framework/application/dia_AppController.h>
#endif

#ifndef __INCLUDED_DIA_EVENT_THREAD__
#include <common/framework/application/dia_EventThread.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_CCA__
#include "common/depricated/SystemAdapter/dia_ISystemCCA.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"
namespace dia {

//-------------------------------------------------------------------------------------------------

BundleApplication::BundleApplication ( BundleConfiguration& bundleConfig )
   : BundleContainer(bundleConfig),
     mInitDone(false)
{}

//-------------------------------------------------------------------------------------------------

BundleApplication::~BundleApplication ( void )
{}

tDiaResult BundleApplication::initializeBundle(void)
{
	ScopeTrace oTrace("BundleApplication::initializeBundle");
	if (mInitDone) return DIA_SUCCESS;
	if (FALSE == amt_bInit())
	{
		DIA_TR_ERR("!!! BundleApplication::initializeBundle => ERROR: amt_bInit failed");
		return DIA_FAILED;
	}
	if (FALSE == scd_init())
	{
		DIA_TR_ERR("!!! BundleApplication::initializeBundle => ERROR: scd_init failed");
		return DIA_FAILED;
	}
	mInitDone = true;
	return DIA_SUCCESS;
}
//-------------------------------------------------------------------------------------------------

tDiaResult
BundleApplication::initializeBundle ( const InitializationLevel& initLevel )
{
   ScopeTrace oTrace("BundleApplication::initializeBundle");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
      DIA_TR_ERR("##### BundleApplication: UNABLE TO GET POINTER TO FACTORY #####");
      return DIA_FAILED;
   }

   if ( ( initLevel.getLevelID() == DIA_EN_INITLEVEL_0 ) || ( initLevel.getLevelID() == DIA_EN_INITLEVEL_1 ) )
   {
      if ( pFactory->setup(initLevel.getLevelID()) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### BundleApplication: FAILED TO SETUP APPLICATION FOR LEVEL '%s' #####",initLevel.getName());
         return DIA_FAILED;
      }
   }

   if ( initLevel.getLevelID() == DIA_EN_INITLEVEL_2 )
   {
      if ( pFactory->setup(initLevel.getLevelID()) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### BundleApplication: FAILED TO SETUP APPLICATION FOR LEVEL '%s' #####",initLevel.getName());
         return DIA_FAILED;
      }

      DIA_TR_USR1("BundleApplication::initializeBundle - Create Customer Lookup-Lists");
      (void) pFactory->makeServiceHandlers(DIA_E_TYPE_CUSTOMER);

      // Create the cca service handler.  It analyses the received cca messages and calls the corresponding handler function
      DIA_TR_USR1("BundleApplication: Create CCA service handler");
      diagnostics_tclApp::getInstance()->poCcaService = new dia_tclService(diagnostics_tclApp::getInstance());
      DIA_TR_USR1("BundleApplication: Create ClientHandlers / SystemAdapters");
      pFactory->makeSystemAdapters();
   }

   if ( initLevel.getLevelID() == DIA_EN_INITLEVEL_3 )
   {
      if ( pFactory->setup(initLevel.getLevelID()) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### BundleApplication: FAILED TO SETUP APPLICATION FOR LEVEL '%s' #####",initLevel.getName());
         return DIA_FAILED;
      }

      // setup internal event thread
      DIA_TR_USR1("BundleApplication: Starting worker thread");
      // start event waiting thread for extComms and Defset (not required for early customer requests
      dia_EventThread* pEventThread = getInstanceOfdiaEventThread();
      DIA_ASSERT(NULL != pEventThread);
   }

   if ( initLevel.getLevelID() == DIA_EN_INITLEVEL_4 )
   {
      if ( pFactory->setup(initLevel.getLevelID()) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### BundleApplication: FAILED TO SETUP APPLICATION FOR LEVEL '%s' #####",initLevel.getName());
         return DIA_FAILED;
      }

      /////////////////////////////////////////////////////////////////////////
      //
      // Runlevel 1 is reached
      //
      /////////////////////////////////////////////////////////////////////////

      getInstanceOfAppController()->vOnEvent(eAppCtrlEvent_InternalSetupDone);

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAG_VAG
      // Create CCA Port Manager
      diagnostics_tclApp::getInstance()->m_poPortMngr = new ahl_tclClientPortMngr(this);
#endif
      // create semaphore to protect the NotificationTable
      DIA_TR_USR1("BundleApplication: Create Notification table and semaphore");
      tS32 s32Result = OSAL_s32SemaphoreCreate(DIAGNOSTICS_NOTTABLE_SEM_NAME, &(diagnostics_tclApp::getInstance()->m_hNotTableSem), 1);
      if(OSAL_ERROR == s32Result)
      {
         diagnostics_tclApp::getInstance()->m_hNotTableSem = OSAL_C_INVALID_HANDLE;
         DIA_TR_ERR("BundleApplication: Creating semaphore FAILED!");
      }
      //create NotificationTable where information about all registered clients is stored
      diagnostics_tclApp::getInstance()->m_poNotTable = new ahl_tclNotificationTable (DIAGNOSTICS_FUNCARRAY_SIZE);
      DIA_ASSERT(OSAL_NULL != diagnostics_tclApp::getInstance()->m_poNotTable);
   }

   tDiaResult retCode = BundleContainer::initializeBundle(initLevel);
   if ( retCode == DIA_SUCCESS )
   {
      DIA_TR_ERR("##### BundleApplication: SUCCEEDED WITH SETTING UP APPLICATION FOR LEVEL '%s' #####",initLevel.getName());
   }
   else
   {
      DIA_TR_ERR("##### BundleApplication: INITIALIZATION OF SUBBUNDLES FOR LEVEL '%s' FAILED (ERR = 0x%08x) #####",initLevel.getName(),retCode);
   }

   return retCode;
}

}
