/*
 * dia_Bundle.cpp
 *
 *  Created on: 01.09.2017
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_BUNDLE_CONFIGURATION__
#include <common/framework/application/dia_BundleConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_BUNDLE__
#include <common/framework/application/dia_Bundle.h>
#endif

namespace dia {

Bundle::Bundle ( BundleConfiguration& bundleConfig )
   : ObjectWithUID(bundleConfig.getName()),
     mpConfig(&bundleConfig),
     mIsConfigValid(bundleConfig.isValid()),
     mIsInitialized(false),
     mIsStarted(false)
{}

Bundle::~Bundle ( void )
{
   delete mpConfig;
   mpConfig = 0;
}

//BundleNullObject::BundleNullObject ( std::string& configName )
//   : Bundle(configName)
//{}

tDiaResult
Bundle::initializeBundle ( const std::list<InitializationLevel*>& initLevels )
{
   ScopeTrace oTrace("Bundle::initializeBundle");

   tDiaResult retCode = DIA_FAILED;

   if ( !(mpConfig->isValid()) )
   {
      DIA_TR_ERR("##### BUNDLE \"%s\" CONFIGURATION PROBLEM DETECTED #####", getName());
      return retCode;
   }

   bool isInitialized = true;

   // as the bundle might have an internal hierarchy we initialize it level by level
   std::list<InitializationLevel*>::const_iterator levelIter = initLevels.begin();
   for ( ; levelIter != initLevels.end(); ++levelIter )
   {
      if ( !(*levelIter )) continue;

      retCode = initializeBundle(*(*levelIter));
      if ( retCode != DIA_SUCCESS )
      {
         isInitialized = false;
         // initialization of this level has been falied. We will not continue with initializing the following levels
         break;
      }
   }

   if ( isInitialized )
   {
      setInitialized(true);
   }

   return retCode;
}

tDiaResult
Bundle::finalizeBundle ( const std::list<InitializationLevel*>& )
{
   return DIA_E_NOT_IMPLEMENTED;
}

}
