/*!
 * \file       dia_BashCommand.h
 *
 * \brief      Wrapper class to execute a bash command
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreUtilis
 *
 * \copyright  (c) 2015-2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef DIA_BASHCOMMAND_H_
#define DIA_BASHCOMMAND_H_

#include <string>

/**
 * \brief Utility class to execute and get the return value of shell commands
 * \details Just executes a given shell command synchronously and gives back
 *          the return value.
 * \ingroup    diaCoreUtilis
 */
class dia_BashCommand
{
public:
   //! \brief Execute bash command and return its return value
   //! Attention! The bash command is not called in another thread.
   //! So the function could lock the current thread for long time.
   static tU8 executeCommand(const char* command);

   //! \brief Execute bash command and return its return value
   //! Attention! The bash command is not called in another thread.
   //! So the function could lock the current thread for long time.
   static tU8 executeCommand(const std::string& cmd);
};

#endif /* DIA_BASHCOMMAND_H_ */
