/*!
 * \file       dia_ApplicationLock.h
 *
 * \brief      Central Mutex Lock for application
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef __INCLUDED_DIA_APPLICATION_LOCK_H_
#define __INCLUDED_DIA_APPLICATION_LOCK_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

#include <common/framework/application/dia_LockScope.h>

namespace dia{

class Lock;

class ApplicationLock {

public:
   static ApplicationLock* createInstance ( void );

   static ApplicationLock* getInstance ( void );

   static void deleteInstance ( void );

protected:
   //! singleton instance
   static ApplicationLock* mpInstance;

   //! protected class constructor
   ApplicationLock ( void ): mLock("ApplicationLock_LK") {}

   //! protected class destructor
   virtual ~ApplicationLock ( void ){}
   
   //Central Lock Object
   mutable Lock mLock;

public:
   //Get Application Lock
   Lock& getAppLock ( void ) {return mLock;}

};

ApplicationLock* createInstanceOfApplicationLock ( void );
ApplicationLock* getInstanceOfApplicationLock ( void );
void releaseInstanceOfApplicationLock ( void );
}

#endif //__INCLUDED_DIA_APPLICATION_LOCK_H_
