/*!
 * \file       dia_ApplicationLauncher.h
 *
 * \brief      Class dia::ApplicationLauncher is responsible for launching (initializing and
 *             starting) the diagnostics application and other diagnostics bundles (collections
 *             of files representing a certain feature or group of features)
 *
 * \details    dia::ApplicationLauncher is responsible for launching the diagnostics application
 *             and other diagnostics bundles
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2012-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the communication of its
 * contents to others without express authorization is prohibited. Offenders will be held liable
 * for the payment of damages. All rights reserved in the event of the grant of a patent, utility
 * model or design.
 */

#ifndef __INCLUDED_DIA_APPLICATION_LAUNCHER__
#define __INCLUDED_DIA_APPLICATION_LAUNCHER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_BUNDLE__
#include <common/framework/application/dia_Bundle.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

namespace dia {

class ApplicationLauncher
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR_WITH_SETUP_AND_TEARDOWN(ApplicationLauncher);

public:
   //! launch the diagnostics application
   virtual tDiaResult launchApplication ( void );
   //! launch the bundle associated with the given name
   virtual tDiaResult launchBundle ( const std::string& bundleName );
protected:
   //! protected class constructor
   ApplicationLauncher ( void );
   //! protected class destructor
   virtual ~ApplicationLauncher ( void );

protected:
   //! synchronization object used to synchronize concurrent access from multiple threads
   mutable Lock syncObj;
   //! flag to indicate that the application was already started
   bool mIsAppAlreadyStarted;
   Bundle* pBundle;
};

}

dia::ApplicationLauncher* getInstanceOfApplicationLauncher ( void );
void releaseInstanceOfApplicationLauncher ( void );

#endif /* __INCLUDED_DIA_APPLICATION_LAUNCHER__ */
