/*
 * dia_Application.cpp
 *
 *  Created on: 12.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION_UDS__
#include "common/depricated/dia_tclDiagSessionUds.h"
#endif

#ifndef __INCLUDED_DIA_EVENT_THREAD__
#include <common/framework/application/dia_EventThread.h>
#endif

using namespace std;

DIA_IMPL_SINGLETON(dia_Application)

#ifndef __DIA_UNIT_TESTING__

dia_Application*
getInstanceOfApplication ( void )
{
   return dia_Application::getInstance();
}

void
releaseInstanceOfApplication ( void )
{
   return dia_Application::deleteInstance();
}

#endif

//-----------------------------------------------------------------------------

dia_Application::dia_Application ( void )
{
//   dia_tclFnctTrace oTrace("dia_Application::dia_Application()");
}

//-----------------------------------------------------------------------------

dia_Application::~dia_Application ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_Application::setup ( void ) const
{
   dia_tclFnctTrace trc("dia_Application::setup");
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Application::shutdown ( void ) const
{
   dia_tclFnctTrace trc("dia_Application::shutdown");
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

//tDiaResult
//dia_Application::postMessage ( const dia_Message& message )
//{
//   return DIA_FAILED;
//}
//

// temporarily
void
dia_Application::postMessage ( dia_tclDiagSession::tclEvent* pEvent ) const
{
   dia_tclFnctTrace oTrace("dia_Application::postMessage()");
   dia_tclDiagSessionUds* pSession = getInstanceOfDiagSessionUDS();
   if ( pSession ) {
      pSession->vEmit(pEvent);
   }
}

tBool dia_Application::postMessage(tU32 pEvent) const
{
    tBool retCode = FALSE;
#ifndef __DIA_UNIT_TESTING__
    dia_EventThread* pEventThread = getInstanceOfdiaEventThread();
    if (pEventThread)
    {
        retCode = pEventThread->bPostEvent(pEvent);
    }
#else
    dia_tclFnctTrace oTrace("dia_Application::postMessage()");
    DIA_PARAMETER_INTENTIONALLY_UNUSED(pEvent);
#endif

    return retCode;
}

////-----------------------------------------------------------------------------
//
//tDiaResult
//dia_Application::addMessageProcessor ( enMsgProcID id, dia_MessageProcessor& proc )
//{
//   tDiaResult retCode = DIA_FAILED;
//
//   map<enMsgProcID,dia_MessageProcessor*>::iterator iter = mMsgProcRep.find(id);
//   if ( iter == mMsgProcRep.end() )
//   {
//      mMsgProcRep[id] = &proc;
//      retCode = DIA_SUCCESS;
//   }
//
//   return retCode;
//}
//
////-----------------------------------------------------------------------------
//
//tDiaResult
//dia_Application::queryMessageProcessor ( enMsgProcID id, dia_MessageProcessor** ppProc )
//{
//   tDiaResult retCode = DIA_FAILED;
//
//   if ( ppProc )
//   {
//      map<enMsgProcID,dia_MessageProcessor*>::iterator iter = mMsgProcRep.find(id);
//      if ( iter != mMsgProcRep.end() )
//      {
//         *ppProc = iter->second;
//         retCode = DIA_SUCCESS;
//      }
//   }
//
//   return retCode;
//}

//----------------------------------------------------------------------------
// Fabricates a response for the UDS state machine without sending to the UDS driver.

void
dia_Application::vNullResponse ( const tU8*, tU16, tCookieType )
{
   dia_tclFnctTrace oTrace("dia_Application::vNullResponse()");

   dia_tclDiagSessionUds* pUdsEngine = getInstanceOfDiagSessionUDS();
   if ( pUdsEngine )
   {
      // here we know that everything is fine with the configuration, so we can stop the timer
      pUdsEngine->oTimer.s32SetTime(0,0);
      // post message to the session queue
      getInstanceOfApplication()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventConfTxOk());
   }
}
