/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief SystemSet Interface - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 Add documentation, sequence diagrams...
*//****************************************************************************/
#ifndef DIAGLIB_SYSTEMSET_IF_H
#define DIAGLIB_SYSTEMSET_IF_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ENUMERATIONS__
#include "Enumerations.h"
#endif

#include "tclDiagnosisIF.h"   //lint !e537 Info 537 , eliminating lint warnings Repeated include file




namespace diaglib {

class tclInterfaceManager; //lint !e763
class tclSystemSetListenerIF; //lint !e763

/**************************************************************************//**
* \brief Interface to provide SystemSet functionality.
*
* Interface to handle systemset requests and send
* answers to these requests. Also use this interface to
* register your provided systemset service IDs.
* See general documentation for a more detailed description
* of the concept this interface follows.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclSystemSetIF : public tclDiagnosisIF
{
protected:
   virtual ~tclSystemSetIF() {}



public:
   /***********************************************************************//**
   * \brief Send result of a system set.
   *
   * Sends a response on a systemset request with the
   * provided parameters and the provided message context.
   * See details on messageContext concept in general docu-
   * mentation.
   *
   * \param[in]      MsgContext  MessageContext sent with request
   * \param[in]      enSystemSetResult The result of this systemset action
   * \param[in]      oErrorList        in case of error: the cause.
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendSystemSetResult (
                                        tenSystemSetResult enSystemSetResult,
                                        const tclParameterVector& oErrorList,
                                        tContext MsgContext
                                      ) = 0;

   /***********************************************************************//**
   * \brief Send result of a system set prepare.
   *
   * Sends a response on a systemset request with the
   * provided parameters and the provided message context.
   * See details on messageContext concept in general documentation.
   *
   * \param[in]      MsgContext  MessageContext sent with request
   * \param[in]      enSystemSetResult The result of this systemset action
   * \param[in]      oErrorList        in case of error: the cause.
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendSystemSetPrepareResult (
                                               tenSystemSetResult enSystemSetResult,
                                               const tclParameterVector& oErrorList,
                                               tContext MsgContext
                                             ) = 0;

   /***********************************************************************//**
   * \brief Send the acknowledge of a system set finish message.
   *
   * Sends a acknowledge on a systemset finish notification.
   * See details on messageContext concept in general documentation.
   *
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bAcknowledgeSystemSetFinished (
                                                 tContext MsgContext
                                               ) = 0;

   /***********************************************************************//**
   * \brief Send result of a system set.check
   *
   * Sends a response on a systemset check request with the
   * provided parameters and the provided message context.
   * See details on messageContext concept in general docu-
   * mentation.
   *
   * \param[in]      MsgContext MessageContext sent with request
   * \param[in]      enSystemSetResult The result of this systemset action
   * \param[in]      oErrorList in case of error: list of parameter IDs
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendSystemSetCheckResult (
                                             tenSystemSetResult enSystemSetResult,
                                             const tclParameterVector& oValueList,
                                             tContext MsgContext
                                           ) = 0;

   /***********************************************************************//**
   * \brief Send a message with a diaglib error code back to diagnosis
   *
   * Sends a response on a system set request in case of an internal error
   *
   * \param[in]      enErrorCode       Internal error that occured
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   ) = 0;

   /***********************************************************************//**
   * \brief Register listener that handles incoming messages.
   *
   * Method to register a listener, that is called on every incoming systemset
   * message of the specified type and ID. This version of the two overloaded
   * methods allows distinction between the different types of incoming
   * systemsets. So components can register listeners for every type of systemset.
   * IMPORTANT:
   * Listener registration for one component is NOT THREAD SAFE! So components
   * either have to register their listeners in sequence in a single thread
   * or have to secure calls to this functions by a semaphore.
   *
   * \param[in]      u32Id ID the given listener should be called for
   * \param[in]      u32SystemSetType SystemSet type the provided listener
   *                 should be called for.
   * \param[in]      SystemSetListener Pointer to listener that is called
   *                 on incoming messages
   *
   * \return         none
   *//*************************************************************************/
   virtual tVoid vRegisterListener (
                                     tU32 u32Id,
                                     tenSystemSetType u32SystemSetType,
                                     tclSystemSetListenerIF* poSystemSetListener
                                   ) = 0;

   /***********************************************************************//**
   * \brief Register listener that handles incoming messages.
   *
   * Method to register a listener, that is called on every incoming systemset
   * message of the specified type and ID. This version of the two overloaded
   * methods does not allow distinction between the different types of incoming
   * systemsets. So components can register only one listener for all types.
   * IMPORTANT:
   * Listener registration for one component is NOT THREAD SAFE! So components
   * either have to register their listeners in sequence in a single thread
   * or have to secure calls to this functions by a semaphore.
   *
   * \param[in]      u32Id - ID the given listener should be called for
   * \param[in]      SystemSetListener Pointer to listener that is called
   *                 on incoming messages
   *
   * \return         none
   *//*************************************************************************/
   virtual tVoid vRegisterListener (
                                     tU32 u32Id,
                                     tclSystemSetListenerIF* poSystemSetListener
                                   ) = 0;
   static tenDiagHandlerInterfaces mInterfaceUID; //lint !e1516: This is supposed to "override" the similar named variable in the base class
};
#ifdef DIAGLIB_STATIC_IF_DEFINES
tenDiagHandlerInterfaces tclSystemSetIF::mInterfaceUID = EN_INTERFACE_SYSTEMSET;
#endif
}
#endif // DIAGLIB_SYSTEMSET_IF_H
