/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief SystemSet Default Listener - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 add documentation,
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_SYSTEMSET_DEF_LISTENER

#include "tclSystemSetDefaultListener.h"

#include "tclSystemSetIF.h"

#include "Trace.h"

namespace diaglib
{

    tclSystemSetDefaultListener::tclSystemSetDefaultListener(tclSystemSetIF* poIF): poSysSetIF(poIF)
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_CONSTRUCTOR);

   if(OSAL_NULL == poIF)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
   }
}

tclSystemSetDefaultListener::~tclSystemSetDefaultListener()
{
//   diaglib_FuncTrace oTrace(I_DIAGLIB_F_DESTRUCTOR);
   poSysSetIF = OSAL_NULL;
}

tU32 tclSystemSetDefaultListener::vOnSystemSet (
                                                 tU32 u32SystemSetID,
                                                 tenSystemSetType enSystemSetType,
                                                 tContext MsgContext
                                               )
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_ON_SYSTEMSET);

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_REC_SYSSET_REQ_DEFHANDLER, u32SystemSetID);
   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_TYPE_OF_RECEIVED_SYSSET_REQUEST, static_cast<tU32>(enSystemSetType));

   tclParameterVector oTmpVec;

   if(poSysSetIF != OSAL_NULL)
   {
      if(TRUE == poSysSetIF->bSendSystemSetResult(EN_SYSTEMSET_OK, oTmpVec, MsgContext))
      {
         DIAGLIB_TRACE_INFO(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_SENDING_POSITIVE_RESPONSE_SUC);
      }
      else
      {
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_ERROR_WHILE_SENDING_MESSAGE);
      }
   }
   else
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
   }


   return U32_DIAGLIB_RETURN_OK;
}


tU32 tclSystemSetDefaultListener::vOnSystemSetFinished (
                                                         tU32 u32SystemSetID,
                                                         tenSystemSetType enSystemSetType,
                                                         tContext MsgContext
                                                       )
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_ON_SYSTEMSET_FINISHED);

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_REC_SYSSET_FINISH_REQ_DEFHANDLER, u32SystemSetID);
   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_TYPE_OF_RECEIVED_SYSSET_REQUEST, static_cast<tU32>(enSystemSetType));

   if(poSysSetIF != OSAL_NULL)
   {
      if(TRUE == poSysSetIF->bAcknowledgeSystemSetFinished(MsgContext))
      {
         DIAGLIB_TRACE_INFO(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_SENDING_POSITIVE_RESPONSE_SUC);
      }
      else
      {
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_ERROR_WHILE_SENDING_MESSAGE);
      }
   }
   else
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
   }


   return U32_DIAGLIB_RETURN_OK;
}


tU32 tclSystemSetDefaultListener::vOnSystemSetPrepare (
                                                         tU32 u32SystemSetID,
                                                         tenSystemSetType enSystemSetType,
                                                         tContext MsgContext
                                                      )
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_ON_SYSTEMSET_PREPARE);

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_REC_SYSSET_PREP_REQ_DEFHANDLER, u32SystemSetID);
   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_TYPE_OF_RECEIVED_SYSSET_REQUEST, static_cast<tU32>(enSystemSetType));

   tclParameterVector oTmpVec;

   if(poSysSetIF != OSAL_NULL)
   {
      if(TRUE == poSysSetIF->bSendSystemSetPrepareResult(EN_SYSTEMSET_OK, oTmpVec, MsgContext))
      {
         DIAGLIB_TRACE_INFO(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_SENDING_POSITIVE_RESPONSE_SUC);
      }
      else
      {
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_ERROR_WHILE_SENDING_MESSAGE);
      }
   }
   else
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
   }


   return U32_DIAGLIB_RETURN_OK;
}

tU32 tclSystemSetDefaultListener::vOnSystemSetCheck (
                                                      tU32 u32SystemSetID,
                                                      tenSystemSetType u32SystemSetType,
                                                      tContext MsgContext
                                                     )
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_ON_SYSTEMSET_CHECK);

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_TYPE_OF_RECEIVED_SYSSET_REQUEST, u32SystemSetID);
   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_TYPE_OF_RECEIVED_SYSSET_REQUEST, static_cast<tU32>(u32SystemSetType));
   DIA_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
   DIA_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );
   tclParameterVector oTmpVec;

   if(poSysSetIF != OSAL_NULL)
   {
      if(TRUE == poSysSetIF->bSendSystemSetCheckResult(EN_SYSTEMSET_OK, oTmpVec, MsgContext))
      {
         DIAGLIB_TRACE_INFO(TR_CLASS_DIAGLIB_SYSTEMSET, I_DIAGLIB_SENDING_POSITIVE_RESPONSE_SUC);
      }
      else
      {
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_ERROR_WHILE_SENDING_MESSAGE);
      }
   }
   else
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_SYSTEMSET, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
   }


   return U32_DIAGLIB_RETURN_OK;
}

}


