/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief IO Control Interface - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
* \Todo 2008-07-10 Add documentation, sequence diagrams ...
* \Todo 2008-07-10 Second send function for "GetResult responses"
*//****************************************************************************/
#ifndef DIAGLIB_ROUTINE_CONTROL_IF_H
#define DIAGLIB_ROUTINE_CONTROL_IF_H


#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#include "tclDiagnosisIF.h"   //lint !e537 Info 537 , eliminating lint warnings Repeated include file




namespace diaglib {
class tclInterfaceManager;    //lint !e763 Info 763 , eliminating lint warnings Redundant declaration for symbol
class tclRoutineControlListenerIF; //lint !e763

/**************************************************************************//**
* \brief Interface to provide Routine control functionality.
*
* Interface to handle routine control requests and send answers to these
* requests. Also use this interface to register your provided routine control
* service IDs. See general documentation for a more detailed description of
* the concept this interface follows.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclRoutineControlIF : public tclDiagnosisIF
{
protected:
   virtual ~tclRoutineControlIF() {}


public:
   /***********************************************************************//**
   * \brief Send result of a routine control start operation.
   *
   * Sends a response on a routine control request with the provided
   * parameters and the provided message context. See details on
   * messageContext concept in general documentation.
   *
   * \param[in]      enRoutineStatus   The result of this routine control action
   * \param[in]      oRoutineResult    Result vesctor or in case of error:
   *                 the cause.
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendRoutineCtrlMethodResult (
                                                tenRoutineCtrlResult enRoutineStatus,
                                                const tclParameterVector& oRoutineResult,
                                                tContext MsgContext
                                              ) = 0;

   /***********************************************************************//**
   * \brief Send a message with a diaglib error code back to diagnosis
   *
   * Sends a response on a routine control request in case of an internal error
   *
   * \param[in]      enErrorCode       Internal error that occured
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   ) = 0;

   /***********************************************************************//**
   * \brief Register listener that handles incoming messages.
   *
   * Method to register a listener, that is called on every incoming Routine control
   * message of the specified ID.
   * IMPORTANT:
   * Listener registration for one component is NOT THREAD SAFE! So components
   * either have to register their listeners in sequence in a single thread
   * or have to secure calls to this functions by a semaphore.
   *
   * \param[in]      u32Id ID the given listener should be called for
   * \param[in]      poRoutineListener Pointer to listener that is called
   *                 on incoming messages
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tVoid vRegisterListener (
                                     tU32 u32Id,
                                     tclRoutineControlListenerIF* poRoutineListener
                                   ) = 0;
   static tenDiagHandlerInterfaces mInterfaceUID; //lint !e1516: This is supposed to "override" the similar named variable in the base class
};
#ifdef DIAGLIB_STATIC_IF_DEFINES
tenDiagHandlerInterfaces tclRoutineControlIF::mInterfaceUID = EN_INTERFACE_ROUTINE_CONTROL;
#endif

}
#endif // DIAGLIB_ROUTINE_CONTROL_IF_H
