/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Helper Functions for components that use diaglib
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_HELPER_FUNCTIONS_H
#define DIAGLIB_HELPER_FUNCTIONS_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

namespace diaglib {

   tclParameterVector oCreateErrorVector(tenInternalError enErrorCode);
   tBool bCheckParameterSignature(const tclParameterVector& oVector, tU32 u32Len, ... );

   tVoid vPushBackU8    (tclParameterVector& oVector, tU8   u8Value  );
   tVoid vPushBackU16   (tclParameterVector& oVector, tU16  u16Value );
   tVoid vPushBackU32   (tclParameterVector& oVector, tU32  u32Value );
   tVoid vPushBackS8    (tclParameterVector& oVector, tS8   s8Value  );
   tVoid vPushBackS16   (tclParameterVector& oVector, tS16  s16Value );
   tVoid vPushBackS32   (tclParameterVector& oVector, tS32  s32Value );
   tVoid vPushBackBool  (tclParameterVector& oVector, tBool bValue   );
   tVoid vPushBackF32   (tclParameterVector& oVector, tF32  f32Value );
   tVoid vPushBackF64   (tclParameterVector& oVector, tF64  f64Value );

   template <typename T>
   T enGetEnumFromParam(tU8 u8Val)
   {
      return (T)u8Val;
   }

   template <typename T>
   T enGetEnumFromParam(tU16 u16Val)
   {
      return (T)u16Val;
   }

   template <typename Tin, typename Tout>
   Tout enGetParamFromEnum(Tin enIn)
   {
      return (Tout)enIn;
   }
}
#endif // DIAGLIB_HELPER_FUNCTIONS_H

