/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief SystemSet Default Listener - Introduced in MFD Nav
*
* (c) 2008-2011 Robert Bosch Car Multimedia GmbH
*
* \Todo 2008-07-10 add documentation,
*//****************************************************************************/
#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_HELPER_FUNCTIONS

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_GENERAL
#include "trcGenProj/Header/tclHelperFunctions.cpp.trc.h"
#endif
#include "tclSystemSetDefaultListener.h"
#include "Trace.h"

namespace diaglib
{
tclParameterVector oCreateErrorVector(tenInternalError enErrorCode)
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_CREATE_ERROR_VECTOR);
   tclParameterVector outVec;
   trParameter outParam;
   outParam.enType = EN_PARAMETER_TYPE_U8ERROR;
   outParam.u8ErrorValue = enErrorCode;

   outVec.push_back(outParam);


   return outVec;
}

//lint -e10  gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint -e26  gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint -e78  gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint -e530 gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint -e516 gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint -e746 gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint -e850 gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)

tBool bCheckParameterSignature(const tclParameterVector& oVector, tU32 u32Len, ... )
{
   ETG_TRACE_USR3_THR(("--> tclHelperFunctions::bCheckParameterSignature"));

   tBool retCode = TRUE;

   size_t u32RealLen = oVector.size();

   if(u32RealLen != u32Len)
   {
      ETG_TRACE_ERR_THR(("!!! tclHelperFunctions::bCheckParameterSignature => ERROR: Len:%d <> %d",u32Len,u32RealLen));
      return FALSE;
   }

   OSAL_tVarArgList args;
   int enExpType;

   OSAL_VarArgStart(args, u32Len); //lint !e10 !e1055 !e746: prio1: Symbol 'diaglib::__va_arg' undeclared, assumed to return int

   for ( tU8 i=0; i<u32Len; ++i)
   {
      tBool errDetected = FALSE;

      enExpType = OSAL_VarArg(args, int); //lint !e1055 !e530 !e10 !e746: "Symbol 'diaglib::__va_start' undeclared, assumed to return int" -> va_start is ANSI standard

      if ( (tenParameterType) enExpType == EN_PARAMETER_TYPE_ARRAY_U8)
      {
         int len = OSAL_VarArg(args, int); //lint !e1055 !e530 !e10 !e746: "Symbol 'diaglib::__va_start' undeclared, assumed to return int" -> va_start is ANSI standard

         for(int j=0; j<len; ++j)
         {
            if ( (oVector[i].enType == EN_PARAMETER_TYPE_U8) && ((tenParameterType)enExpType == EN_PARAMETER_TYPE_ARRAY_U8) )
            {
               // this is currently correct because we have no array struct
            }
            else
            {
//             OSAL_VarArgEnd(args);
               ETG_TRACE_ERR_THR(("!!! tclHelperFunctions::bCheckParameterSignature => ERROR: enType FAILED %d<>%d",oVector[i].enType,(tenParameterType)enExpType ));
               errDetected = TRUE;
               break;
            }
            if(j<(len-1)) // because of ++i of for loop
            {
               i++;
            }
         }
      }
      else
      {
         if(oVector[i].enType != (tenParameterType)enExpType)
         {
//          OSAL_VarArgEnd(args);
            ETG_TRACE_ERR_THR(("!!! tclHelperFunctions::bCheckParameterSignature => ERROR: enType FAILED %d<>%d",oVector[i].enType,(tenParameterType)enExpType ));
            errDetected = TRUE;
         }
      }

      if ( errDetected == TRUE )
      {
         retCode = FALSE;
         break;
      }
   }

   OSAL_VarArgEnd(args); //lint !e850 Info: for loop index variable whose type category is 'integral' is modified in body of the for loop
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   ETG_TRACE_USR3_THR(("<-- tclHelperFunctions::bCheckParameterSignature"));
#endif
   return retCode;
}

//lint +e10  gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint +e26  gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint +e78  gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint +e530 gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint +e516 gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint +e746 gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)
//lint +e850 gib2hi: lint issue is caused by using OSAL_VarArg like macros (take over from previous projects)

tVoid vPushBackU8    (tclParameterVector& oVector, tU8   u8Value  )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_U8;
   rParam.u8Value = u8Value;
   oVector.push_back(rParam);
}

tVoid vPushBackU16   (tclParameterVector& oVector, tU16  u16Value )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_U16;
   rParam.u16Value = u16Value;
   oVector.push_back(rParam);
}

tVoid vPushBackU32   (tclParameterVector& oVector, tU32  u32Value )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_U32;
   rParam.u32Value = u32Value;
   oVector.push_back(rParam);
}

tVoid vPushBackS8    (tclParameterVector& oVector, tS8   s8Value  )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_S8;
   rParam.s8Value = s8Value;
   oVector.push_back(rParam);
}

tVoid vPushBackS16   (tclParameterVector& oVector, tS16  s16Value )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_S16;
   rParam.s16Value = s16Value;
   oVector.push_back(rParam);
}

tVoid vPushBackS32   (tclParameterVector& oVector, tS32  s32Value )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_S32;
   rParam.s32Value = s32Value;
   oVector.push_back(rParam);
}

tVoid vPushBackBool  (tclParameterVector& oVector, tBool bValue   )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_BOOL;
   rParam.bValue = bValue;
   oVector.push_back(rParam);
}

tVoid vPushBackF32   (tclParameterVector& oVector, tF32  f32Value )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_F32;
   rParam.f32Value = f32Value;
   oVector.push_back(rParam);
}

tVoid vPushBackF64   (tclParameterVector& oVector, tF64  f64Value )
{
   diaglib::trParameter rParam;
   rParam.enType = diaglib::EN_PARAMETER_TYPE_F64;
   rParam.f64Value = f64Value;
   oVector.push_back(rParam);
}


}
