/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief DiagData Interface - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*
* \Todo 2008-07-10 Add more documentation
*//****************************************************************************/
#ifndef DIAGLIB_DIAGNOSIS_DATA_IF_H
#define DIAGLIB_DIAGNOSIS_DATA_IF_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "diaglib_common.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h"
#endif

#include "Enumerations.h"           //lint !e537 Info 537 , eliminating lint warnings Repeated include file
#include "tclDiagnosisIF.h"         //lint !e537 Info 537 , eliminating lint warnings Repeated include file

namespace diaglib {

class tclInterfaceManager;          //lint !e763 Info 763 , eliminating lint warnings Redundant declaration for symbol
class tclDiagnosisDataListenerIF; //lint !e763

/**************************************************************************//**
* \brief Interface to handle diagnosis data communication
*
* Interface to handle diagnosis data requests and send answers to these
* requests. Also use this interface to register your provided diagnosis data
* service IDs. See general documentation for a more detailed description of the
* concept this interface follows.
*
* \ingroup        diaglibAPI
*//****************************************************************************/
class tclDiagnosisDataIF : public tclDiagnosisIF
{
protected:
   virtual ~tclDiagnosisDataIF() {}

public:
   /***********************************************************************//**
   * \brief Send result of diagnosis read operation.
   *
   * Sends a response on a diagnosis data read request with the provided
   * parameters and the provided message context. See details on messageContext
   * concept in general documentation.
   *
   * \param[in]      MsgContext  MessageContext sent with request
   * \param[in]      enReadResult      The result of the read operation
   * \param[in]      oReadValues       ID specific: the read values, or in case
   *                                   of error: the cause.
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendDiagnosisDataResult   (
                                                     tenDiagDataResult enReadResult,
                                                     const tclParameterVector& oValues,
                                                     tContext context
                                                  ) = 0;


   /***********************************************************************//**
   * \brief Send a message with a diaglib error code back to diagnosis
   *
   * Sends a response on a diag data request in case of an internal error
   *
   * \param[in]      enErrorCode       Internal error that occured
   * \param[in]      MsgContext  MessageContext sent with request
   *
   * \return         boolean that indicates message delivery was successful
   *//*************************************************************************/
   virtual tBool bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   ) = 0;

   /***********************************************************************//**
   * \brief Register listener that handles incoming messages.
   *
   * Method to register a listener, that is called on every incoming diagnosis
   * data message of the ID.
   * IMPORTANT:
   * Listener registration for one component is NOT THREAD SAFE! So components
   * either have to register their listeners in sequence in a single thread
   * or have to secure calls to this functions by a semaphore.
   *
   * \param[in]      u32Id ID the given listener should be called for
   * \param[in]      poDiagDataListener Pointer to listener that is called
   *                 on incoming messages
   *
   * \return         none
   *//*************************************************************************/
   virtual tVoid vRegisterListener ( tU32 u32Id, tclDiagnosisDataListenerIF* poDiagDataListener ) = 0;
   static tenDiagHandlerInterfaces mInterfaceUID; //lint !e1516: This is supposed to "override" the similar named variable in the base class
};

#ifdef DIAGLIB_STATIC_IF_DEFINES
tenDiagHandlerInterfaces tclDiagnosisDataIF::mInterfaceUID = EN_INTERFACE_DIAGNOSIS_DATA;
#endif

}
#endif // DIAGLIB_DIAGNOSIS_DATA_IF_H

