/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Routine control handler - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_ROUTINE_CONTROL_HANDLER_H
#define DIAGLIB_ROUTINE_CONTROL_HANDLER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#include "../tclServiceHandler.h"
#include "../tclRoutineControlIF.h"          //lint !e537 Info 537 , eliminating lint warnings Repeated include file
#include "../tclRoutineControlListenerIF.h"  //lint !e537 Info 537 , eliminating lint warnings Repeated include file

#include <utility>
#include <map>
using std::map;

namespace diaglib {

class tclRoutineControlHandler : public tclRoutineControlIF, public tclRoutineControlListenerIF
{

private:
   friend class tclInterfaceManager;

   tclServiceHandler* poService;
   tclInterfaceManager* poManager;
   virtual ~tclRoutineControlHandler();
   map<tU32, tclRoutineControlListenerIF*> oListenerMap;

public:
    tclRoutineControlHandler(); // Not implemented, do not use

   tclRoutineControlHandler (
                                 tclServiceHandler* poServiceHandler,
                                 tclInterfaceManager* poResponsibleManager
                              );


   virtual tBool bSendRoutineCtrlMethodResult (
                                                tenRoutineCtrlResult enRoutineStatus,
                                                const tclParameterVector& oRoutineResult,
                                                tContext MsgContext
                                              );

   virtual tBool bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   );

   virtual tVoid vRegisterListener ( tU32 u32Id, tclRoutineControlListenerIF* poRoutineListener );

   virtual tU32 vOnGetRoutineResult (
                                      tU32 u32RoutineId,
                                      tContext MsgContext
                                    );

   virtual tU32 vOnRoutineControlAbort (
                                         tU32 u32RoutineId,
                                         tContext MsgContext
                                       );

   virtual tU32 vOnRoutineControlStart (
                                         tU32 u32RoutineId,
                                         tU32 u32Bitmask,
                                         const tclParameterVector& oParamVector,
                                         tContext MsgContext
                                       );

   tVoid vSendRoutineCtrlIdNotSupported(tContext MsgContext);

   virtual tclDiagnosisIF* poGetInterface(tenDiagHandlerInterfaces enInterfaceId);
};
}
#endif // DIAGLIB_ROUTINE_CONTROL_HANDLER_H


