/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief IO Control Handler - Diagnosis library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_IO_CONTROL_HANDLER_H
#define DIAGLIB_IO_CONTROL_HANDLER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#include "../tclServiceHandler.h"
#include "../tclIoControlIF.h"
#include "../tclIoControlListenerIF.h"

using std::map;

namespace diaglib {

class tclInterfaceManager; //lint !e763 Info 763 , eliminating lint warnings Redundant declaration for symbol

class tclIoControlHandler : public tclIoControlIF, public tclIoControlListenerIF
{
private:
   friend class tclInterfaceManager;
   tclServiceHandler* poService;
   tclInterfaceManager* poManager;
   virtual ~tclIoControlHandler();
   map<tU32, tclIoControlListenerIF*> oListenerMap;

public:
    tclIoControlHandler(); // Not implemented, do not use
   // Todo: Registration to service handler needs to be done
   tclIoControlHandler (
                           tclServiceHandler* poServiceHandler,
                           tclInterfaceManager* poResponsibleManager
                        );


   virtual tBool bSendIoCtrlMethodResult   (
                                              tenIoCtrlResult enIoResult,
                                              tenIoControlAction enAction,
                                              const tclParameterVector& oResultList,
                                              tContext MsgContext
                                           );

   virtual tBool bSendIoCtrlFreezeResult   (
                                              tenIoCtrlResult enIoResult,
                                              tContext MsgContext
                                           );

   virtual tBool bSendIoCtrlUnfreezeResult   (
                                              tenIoCtrlResult enIoResult,
                                              tContext MsgContext
                                           );

   virtual tBool bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   );

   virtual tU32 vOnIoControl (
                               tU32 u32IoControlId,
                               tenIoControlAction enActionId,
                               const tclParameterVector& oParameterVector,
                               tContext MsgContext
                             );

   virtual tU32 vOnIoControlFreeze (
                               tU32 u32IoControlId,
                               tContext MsgContext
                             );

   virtual tU32 vOnIoControlUnfreeze (
                            tU32 u32IoControlId,
                            tContext MsgContext
                          );

   virtual tVoid vSendIoCtrlIdNotSupported(tenIoControlAction enActionId, tContext MsgContext);

   virtual tVoid vRegisterListener ( tU32 u32Id, tclIoControlListenerIF* poIoListener );

   virtual tclDiagnosisIF* poGetInterface(tenDiagHandlerInterfaces enInterfaceId);

};
}
#endif // DIAGLIB_IO_CONTROL_HANDLER_H

