/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief IO control handler - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_IOCTRL_HANDLER

#include "tclIoControlHandler.h"

#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


#include "../tclInterfaceManager.h"
#include "../tclIoControlListenerIF.h"
#include "../tclHelperFunctions.h"
#include "../Trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_IOCONTROL
#include "trcGenProj/Header/tclIoControlHandler.cpp.trc.h"
#endif

namespace diaglib {


tclIoControlHandler::tclIoControlHandler (
                                                      tclServiceHandler* poServiceHandler,
                                                      tclInterfaceManager* poResponsibleManager
                                                   ):
                                                      poService(poServiceHandler),
                                                      poManager(poResponsibleManager)
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::tclIoControlHandler"));

   if(poServiceHandler == OSAL_NULL)
   {
      ETG_TRACE_COMP_THR(( "!!! tclIoControlHandler::tclIoControlHandler => ERROR: poServiceHandler == OSAL_NULL"));
   }
   else if(poResponsibleManager == OSAL_NULL)
   {
      ETG_TRACE_COMP_THR(( "!!! tclIoControlHandler::tclIoControlHandler => ERROR: poResponsibleManager == OSAL_NULL"));
   }


   if(poService != OSAL_NULL)
   {
      poService->vRegisterIoControlListener(this);
   }

    ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::tclIoControlHandler"));
}

tclIoControlHandler::~tclIoControlHandler()
{
   poManager = OSAL_NULL;
   poService = OSAL_NULL;
   _BP_TRY_BEGIN
   {
       oListenerMap.clear();
   }
   _BP_CATCH_ALL
   {

   }
   _BP_CATCH_END
}

tBool tclIoControlHandler::bSendIoCtrlMethodResult   (
                                           tenIoCtrlResult enIoResult,
                                           tenIoControlAction enAction,
                                           const tclParameterVector& oResultList,
                                           tContext MsgContext
                                        )
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::bSendIoCtrlMethodResult"));

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_COMP_THR(( "!!! tclIoControlHandler::bSendIoCtrlMethodResult => ERROR: OSAL_NULL == poService"));
      return FALSE;
   }
   ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::bSendIoCtrlMethodResult => AppId=%d",poService->u32GetAppIdentifier()));
   tBool bResult;
   if(OSAL_NULL == MsgContext)
   {
      ETG_TRACE_COMP_THR(( "!!! tclIoControlHandler::bSendIoCtrlMethodResult => ERROR: OSAL_NULL == MsgContext"));
      bResult =  false;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::bSendIoCtrlMethodResult => MsgContext=%d",static_cast<tU32>(MsgContext)));
      bResult = poService->bSendIoCtrlMethodResult ( enIoResult,
                                                     enAction,
                                                     oResultList,
                                                     MsgContext
                                                    );

   }

   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::bSendIoCtrlMethodResult"));

   return bResult;
}

tBool tclIoControlHandler::bSendIoCtrlFreezeResult   (
                                                          tenIoCtrlResult enIoResult,
                                                          tContext MsgContext
                                                       )
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::bSendIoCtrlFreezeResult"));

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_COMP_THR(( "!!! tclIoControlHandler::bSendIoCtrlFreezeResult => ERROR: OSAL_NULL == poService"));
      return FALSE;
   }
   ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::bSendIoCtrlFreezeResult => AppId=%d",poService->u32GetAppIdentifier()));
   tBool bResult;
   if(OSAL_NULL == MsgContext)
   {
      ETG_TRACE_COMP_THR(( "!!! tclIoControlHandler::bSendIoCtrlFreezeResult => ERROR: OSAL_NULL == MsgContext"));
      bResult =  false;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::bSendIoCtrlFreezeResult => MsgContext=%d",static_cast<tU32>(MsgContext)));
      bResult = poService->bSendIoCtrlFreezeResult ( enIoResult,
                                                     MsgContext
                                                    );

   }

   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::bSendIoCtrlFreezeResult"));

   return bResult;
}

tBool tclIoControlHandler::bSendIoCtrlUnfreezeResult   (
                                                             tenIoCtrlResult enIoResult,
                                                             tContext MsgContext
                                                          )
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::bSendIoCtrlUnfreezeResult"));

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_COMP_THR(( "!!! tclIoControlHandler::bSendIoCtrlUnfreezeResult => ERROR: OSAL_NULL == poService"));
      return FALSE;
   }
   ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::bSendIoCtrlUnfreezeResult => AppId=%d",poService->u32GetAppIdentifier()));
   tBool bResult;
   if(OSAL_NULL == MsgContext)
   {
      ETG_TRACE_COMP_THR(( "!!! tclIoControlHandler::bSendIoCtrlUnfreezeResult => ERROR: OSAL_NULL == MsgContext"));
      bResult =  false;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::bSendIoCtrlUnfreezeResult => MsgContext=%d",static_cast<tU32>(MsgContext)));
      bResult = poService->bSendIoCtrlUnfreezeResult ( enIoResult,
                                                     MsgContext
                                                    );

   }

   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::bSendIoCtrlUnfreezeResult"));

   return bResult;
}


tBool tclIoControlHandler::bSendDiaglibError (
                                                   tenInternalError enErrorCode,
                                                   tContext MsgContext
                                               )
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::bSendDiaglibError"));
   diaglib_FuncTrace fnctrc(I_DIAGLIB_F_SEND_DIAGLIB_ERROR);

   tclParameterVector oResultVector;
   oResultVector = oCreateErrorVector(enErrorCode);

   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::bSendDiaglibError"));
   return bSendIoCtrlMethodResult( EN_IO_CONTROL_NOT_OK,
                                   EN_ACTION_FREEZE,
                                   oResultVector,
                                   MsgContext
                                 );
}

tVoid tclIoControlHandler::vRegisterListener ( tU32 u32Id, tclIoControlListenerIF* poIoListener )
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::vRegisterListener"));
   if(OSAL_NULL == poService)
   {
      ETG_TRACE_ERR_THR(( "!!!tclIoControlHandler::vRegisterListener => ERROR: OSAL_NULL == poService"));
      return;
   }

   if(OSAL_NULL == poIoListener)
   {
      ETG_TRACE_ERR_THR(( "!!!tclIoControlHandler::vRegisterListener => ERROR: OSAL_NULL == poIoListener"));
      return;
   }

   ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::vRegisterListener => Id:%d",u32Id));
   oListenerMap[u32Id] = poIoListener;
   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::vRegisterListener"));
}

tclDiagnosisIF* tclIoControlHandler::poGetInterface(tenDiagHandlerInterfaces u16InterfaceId)
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::poGetInterface"));

   tclDiagnosisIF* poReturnIF;

   poReturnIF = poManager->poGetInterface(u16InterfaceId);

   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::poGetInterface"));
   return poReturnIF;
}


tU32 tclIoControlHandler::vOnIoControl (
                                              tU32 u32IoControlId,
                                              tenIoControlAction enActionId,
                                              const tclParameterVector& oParameterVector,
                                              tContext MsgContext
                                            )
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::vOnIoControl"));
   tU32 u32Ret = U32_DIAGLIB_RETURN_OK;

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_ERR_THR(( "!!! tclIoControlHandler::vOnIoControl => ERROR: OSAL_NULL == poService"));
      return U32_DIAGLIB_RETURN_NOT_OK;
   }

   std::map<tU32, tclIoControlListenerIF*>::iterator iter = oListenerMap.find(u32IoControlId);
   if ( iter == oListenerMap.end() )
   {
      ETG_TRACE_ERR_THR(( "!!!tclIoControlHandler::vOnIoControl => Unkown AppId %d",poService->u32GetAppIdentifier()));
      ETG_TRACE_ERR_THR(( "!!!tclIoControlHandler::vOnIoControl => Unkown Control ID %d",u32IoControlId));
      vSendIoCtrlIdNotSupported(enActionId, MsgContext);
      u32Ret = U32_DIAGLIB_RETURN_OK;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::vOnIoControl => Forwarding Message to Listener"));
      u32Ret = oListenerMap[u32IoControlId]->vOnIoControl(
            u32IoControlId,
            enActionId,
            oParameterVector,
            MsgContext
      );
   }

   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::vOnIoControl"));
   return u32Ret;
}


tU32 tclIoControlHandler::vOnIoControlFreeze (
                                              tU32 u32IoControlId,
                                              tContext MsgContext
                                            )
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::vOnIoControlFreeze"));
   tU32 u32Ret = U32_DIAGLIB_RETURN_OK;

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_ERR_THR(( "!!! tclIoControlHandler::vOnIoControlFreeze => ERROR: OSAL_NULL == poService"));
      return U32_DIAGLIB_RETURN_NOT_OK;
   }

   std::map<tU32, tclIoControlListenerIF*>::iterator iter = oListenerMap.find(u32IoControlId);
   if ( iter == oListenerMap.end() )
   {
      ETG_TRACE_ERR_THR(( "!!!tclIoControlHandler::vOnIoControlFreeze => Unkown AppId %d",poService->u32GetAppIdentifier()));
      ETG_TRACE_ERR_THR(( "!!!tclIoControlHandler::vOnIoControlFreeze => Unkown Control ID %d",u32IoControlId));
      vSendIoCtrlIdNotSupported(EN_ACTION_FREEZE, MsgContext);
      u32Ret = U32_DIAGLIB_RETURN_OK;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::vOnIoControlFreeze => Forwarding Message to Listener"));
      u32Ret = oListenerMap[u32IoControlId]->vOnIoControlFreeze(
            u32IoControlId,
            MsgContext
      );
   }

   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::vOnIoControlFreeze"));
   return u32Ret;
}


tU32 tclIoControlHandler::vOnIoControlUnfreeze (
                                              tU32 u32IoControlId,
                                              tContext MsgContext
                                            )
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::vOnIoControlUnfreeze"));
   tU32 u32Ret = U32_DIAGLIB_RETURN_OK;

   if(OSAL_NULL == poService)
   {
      ETG_TRACE_ERR_THR(( "!!! tclIoControlHandler::vOnIoControlUnfreeze => ERROR: OSAL_NULL == poService"));
      return U32_DIAGLIB_RETURN_NOT_OK;
   }

   std::map<tU32, tclIoControlListenerIF*>::iterator iter = oListenerMap.find(u32IoControlId);
   if ( iter == oListenerMap.end() )
   {
      ETG_TRACE_ERR_THR(( "!!!tclIoControlHandler::vOnIoControlUnfreeze => Unkown AppId %d",poService->u32GetAppIdentifier()));
      ETG_TRACE_ERR_THR(( "!!!tclIoControlHandler::vOnIoControlUnfreeze => Unkown Control ID %d",u32IoControlId));
      vSendIoCtrlIdNotSupported(EN_ACTION_UNFREEZE, MsgContext);
      u32Ret = U32_DIAGLIB_RETURN_OK;
   }
   else
   {
      ETG_TRACE_COMP_THR(( "--- tclIoControlHandler::vOnIoControlUnfreeze => Forwarding Message to Listener"));
      u32Ret = oListenerMap[u32IoControlId]->vOnIoControlUnfreeze(
            u32IoControlId,
            MsgContext
      );
   }

   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::vOnIoControlUnfreeze"));
   return u32Ret;
}

tVoid tclIoControlHandler::vSendIoCtrlIdNotSupported(tenIoControlAction enActionId, tContext MsgContext)
{
   ETG_TRACE_USR3_THR(( "--> tclIoControlHandler::vSendIoCtrlIdNotSupported"));

   tclParameterVector oErrorVector;

   trParameter rErrorParam;
   rErrorParam.enType = EN_PARAMETER_TYPE_U8ERROR;
   rErrorParam.u8ErrorValue = EN_ERROR_ID_NOT_SUPPORTED;

   oErrorVector.push_back(rErrorParam);

   bSendIoCtrlMethodResult (
                                    EN_IO_CONTROL_NOT_OK,
                                    enActionId,
                                    oErrorVector,
                                    MsgContext
                                );
   ETG_TRACE_USR3_THR(( "<-- tclIoControlHandler::vSendIoCtrlIdNotSupported"));

}

}// namespace diaglib {

