/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief DiagData Handler - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_DIAGDATA_HANDLER_H
#define DIAGLIB_DIAGDATA_HANDLER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#include "../tclDiagnosisDataIF.h"
#include "../tclServiceHandler.h"
#include "../tclDiagnosisDataListenerIF.h"


using std::map;

namespace diaglib {

class tclDiagDataHandler : public tclDiagnosisDataIF,
                           public tclDiagnosisDataListenerIF
{
private:
   friend class tclInterfaceManager;

   tclServiceHandler* poService;
   tclInterfaceManager* poManager;
   virtual ~tclDiagDataHandler();
   map<tU32, tclDiagnosisDataListenerIF*> oListenerMap;

public:
    tclDiagDataHandler(); // Not implemented, do not use
   tclDiagDataHandler (
                                 tclServiceHandler* poServiceHandler,
                                 tclInterfaceManager* poResponsibleManager
                              );

   virtual tBool bSendDiagnosisDataResult   (
                                                     tenDiagDataResult enReadResult,
                                                     const tclParameterVector& oReadValues,
                                                     tContext MsgContext
                                                  );


   virtual tBool bSendDiaglibError (
                                       tenInternalError enErrorCode,
                                       tContext MsgContext
                                   );


   virtual tU32 vOnDiagnosisDataWrite (
                                            tU32 u32DiagDataId,
                                            const diaglib::tclParameterVector& oParamVector,
                                            diaglib::tContext MsgContext
                                            );

   virtual tU32 vOnDiagnosisDataRead (
                                          tU32 u32DiagDataId,
                                          diaglib::tContext MsgContext
                                         );

   virtual tVoid vSendDiagnosisDataIdNotSupported(tContext MsgContext);

   virtual tVoid vRegisterListener ( tU32 u32Id, tclDiagnosisDataListenerIF* poDiagDataListener );

   virtual tclDiagnosisIF* poGetInterface(tenDiagHandlerInterfaces enInterfaceId);

};
}
#endif // DIAGLIB_DIAGDATA_HANDLER_H


