/**************************************************************************//**
* \file Enumerations.h
* \brief Enumerations and types used in diagnosis library.
*
* Various enumerations used to identify interfaces and protocols, or enums that
* are used in diagnosis communication to specify certain status, results, requests
*
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifndef __INCLUDED_DIAGLIB_ENUMERATIONS__
#define __INCLUDED_DIAGLIB_ENUMERATIONS__

#include <vector>

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h" //lint !e451 Warning: Header file repeatedly included but does not have a standard include guard
#endif

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>                         //lint !e537 Info 537 , eliminating lint warnings Repeated include file


namespace diaglib {

#ifndef __INCLUDED_SYSTEM_ADAPTER_DATA_TYPES__
#include "../depricated/SystemAdapter/dia_DataTypes.h"
#endif

const tU32 U32_DIAGLIB_RETURN_OK = 0;
const tU32 U32_DIAGLIB_RETURN_NOT_OK = 1;
typedef tU32 tContext;

/**
 * Vector of values.
 *
 * Use like a standard STL vector of trParameter.
 * In the diagnosis interfaces this type is used to transport
 * parameters, results and error values as specified in diagnosis
 * protocol or per ID in the IDspec XML file.
 * \ingroup        diaglibAPI
 */
typedef std::vector<trParameter> tclParameterVector;

/**
 * \name Administrative types
 * Types used to configure the library and for administrative tasks
 * \ingroup        diaglibAPI
 */
/*@{*/
/** 
 * Available interfaces in diaglib. Use to request additional interfaces
 * \ingroup        diaglibAPI
 */
enum tenDiagHandlerInterfaces
{
   EN_INTERFACE_DIAGNOSIS = 0,
   EN_INTERFACE_CCA_SERVICE = 1,
   EN_INTERFACE_CSFW_SERVICE = 2,
   EN_INTERFACE_SYSTEMSET = 3,
   EN_INTERFACE_IO_CONTROL = 4,
   EN_INTERFACE_ROUTINE_CONTROL = 5,
   EN_INTERFACE_DIAGNOSIS_DATA = 6
};

/** 
 * Available protocols of diaglib. Use to specifiy what protocol to use
 * in diagnosis communication.
 * \ingroup        diaglibAPI
 */
enum tenSupportedProtocols
{
   EN_PROTOCOL_UNDEFINED = 0,
   EN_PROTOCOL_CCA = 1,
   EN_PROTOCOL_CSFW = 2
};
/*@}*/
}

#endif
