/**************************************************************************//**
* \file           tclServiceDiaglib.cpp
* \author         AI/PJ-FO45 - Evers
* \date           2010-08-04
*
* \brief Service Handler - Diagnosis Library (diaglib)
*
* (c) 2010 Bosch Car Multimedia GmbH
*//****************************************************************************/
#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif


// MIDW_FI DEFINES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS

// FI DEFINES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "tclServiceDiaglib.h"
#define DIAGLIB_INCLUDE_GENERIC
#include "common/diaglib/diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_SERVICE_DIAGLIB
#include "../Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_GENERAL
#include "trcGenProj/Header/tclServiceDiaglib.cpp.trc.h"
#endif



#define DIAGLIB_U16_CCA_SERVICE_MAJOR_VERSION 0x0001
#define DIAGLIB_U16_CCA_SERVICE_MINOR_VERSION 0x0000
#define DIAGLIB_U16_CCA_SERVICE_PATCH_VERSION 0x0000

namespace diaglib {

BEGIN_MSG_MAP(tclServiceDiaglibOneThread, ahl_tclBaseWork)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL,      vHandleAllMessages)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_GETROUTINERESULT,    vHandleAllMessages)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_IOCONTROL,           vHandleAllMessages)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_SYSTEMSETPREPARE,    vHandleAllMessages)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_SYSTEMSETFINISHED,   vHandleAllMessages)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_SYSTEMSET,           vHandleAllMessages)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA,       vHandleAllMessages)
END_MSG_MAP()

tclServiceDiaglibOneThread::tclServiceDiaglibOneThread():
    ahl_tclBaseOneThreadService( OSAL_NULL,
                                 0,
                                 0,
                                 0,
                                 0
                               ),
   _poDiagIF(OSAL_NULL),
   _poCcaIF(OSAL_NULL),
   _poSysSetIF(OSAL_NULL),
   _poRoutineCtrlIF(OSAL_NULL),
   _poIoCtrlIF(OSAL_NULL),
   _poDiagDataIF(OSAL_NULL)
{
}

tclServiceDiaglibOneThread::tclServiceDiaglibOneThread(ahl_tclBaseOneThreadApp* poApp, tU8 u8ExpectedMajorDiaglibVer):
    ahl_tclBaseOneThreadService( poApp,
                                 CCA_C_U16_SRV_DIAGLIB,
                                 DIAGLIB_U16_CCA_SERVICE_MAJOR_VERSION,
                                 DIAGLIB_U16_CCA_SERVICE_MINOR_VERSION,
                                 DIAGLIB_U16_CCA_SERVICE_PATCH_VERSION
                               ),
   _poDiagIF(OSAL_NULL),
   _poCcaIF(OSAL_NULL),
   _poSysSetIF(OSAL_NULL),
   _poRoutineCtrlIF(OSAL_NULL),
   _poIoCtrlIF(OSAL_NULL),
   _poDiagDataIF(OSAL_NULL)
{
   tclDiagnosisInterfaceFactory* poFactory = tclDiagnosisInterfaceFactory::poGetInstance();

   if(poFactory != OSAL_NULL)
   {
      tU8 u8MajorVersion;
      tU8 u8MinorVersion;
      if(poFactory->bGetVersion(u8MajorVersion, u8MinorVersion) == TRUE)
      {
         // +++ Trace info diaglib version number if wanted +++
         if(u8MajorVersion != u8ExpectedMajorDiaglibVer)
         {
            ETG_TRACE_ERR_THR(( "!!! tclServiceDiaglibOneThread::tclServiceDiaglib => ERROR: major version differs from expected one"));
         }
      }
      else
      {
         // +++ Trace warning +++
      }

      // +++ Provide pointer to your Main application that derives from ail_tclAppInterface as tVoid* +++
      _poDiagIF = poFactory->poCreateDiagnosisInterface( EN_PROTOCOL_CCA, OSAL_NULL );
   }
   else
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceDiaglibOneThread::tclServiceDiaglib => ERROR: OSAL_NULL == poFactory"));
   }

   if(_poDiagIF != OSAL_NULL)
   {
      _poDiagIF->bGetInterface<tclCCAServiceIF>(&_poCcaIF);

      if(_poCcaIF != OSAL_NULL)
      {
          _poCcaIF->vSetApplication(poApp);
      }

      // +++ Get the additional interfaces you need  +++
      _poDiagIF->bGetInterface<tclSystemSetIF>(&_poSysSetIF);
      _poDiagIF->bGetInterface<tclRoutineControlIF>(&_poRoutineCtrlIF);
      _poDiagIF->bGetInterface<tclIoControlIF>(&_poIoCtrlIF);
      _poDiagIF->bGetInterface<tclDiagnosisDataIF>(&_poDiagDataIF);
   }
   else
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceDiaglibOneThread::tclServiceDiaglib => ERROR: OSAL_NULL == _poDiagIF"));
   }

   // +++ Check if an interface failed creation +++
   if (
         _poCcaIF == OSAL_NULL          ||
         _poSysSetIF == OSAL_NULL       ||
         _poRoutineCtrlIF == OSAL_NULL  ||
         _poIoCtrlIF == OSAL_NULL       ||
         _poDiagDataIF == OSAL_NULL
      )
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceDiaglibOneThread::tclServiceDiaglib => ERROR: Somepointer are NULL"));
   }
}

tclServiceDiaglibOneThread::~tclServiceDiaglibOneThread()
{
    tclDiagnosisInterfaceFactory* poFactory = OSAL_NULL;
    _BP_TRY_BEGIN
    {

        poFactory = tclDiagnosisInterfaceFactory::poGetInstance();

        if( _poDiagIF != OSAL_NULL )
        {
            // +++ Destroy your diaglib instance by calling the following function and providind ONE of +++
            // +++ your interfaces. All interfaces are invalid after this function returned true. +++
            (tVoid)poFactory->bDeleteConnectionAndFreeInterfaces( _poDiagIF );
        }
        else
        {
            // +++ Trace error +++
           ETG_TRACE_ERR_THR(( "!!! tclServiceDiaglibOneThread::~tclServiceDiaglib => ERROR: OSAL_NULL == _poDiagIF"));
        }
    }
    _BP_CATCH_ALL
    {
      ETG_TRACE_ERR_THR(( "!!! tclServiceDiaglibOneThread::~tclServiceDiaglib => ERROR: CATCH FAULT"));
    }
    _BP_CATCH_END

    _poDiagIF        = OSAL_NULL;
    _poCcaIF         = OSAL_NULL;
    _poSysSetIF      = OSAL_NULL;
    _poRoutineCtrlIF = OSAL_NULL;
    _poIoCtrlIF      = OSAL_NULL;
    _poDiagDataIF    = OSAL_NULL;
         // +++ Trace error +++
      // +++ Trace error +++
}



tVoid
tclServiceDiaglibOneThread::vOnServiceAvailable()
{
    // Diaglib does not need to do anything when ServiceAvailabilty changes
}

tVoid
tclServiceDiaglibOneThread::vOnServiceUnavailable()
{
    // Diaglib does not need to do anything when ServiceAvailabilty changes
}

tBool
tclServiceDiaglibOneThread::bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg)
{
    // Diaglib does not offer any properties
    DIA_PARAMETER_INTENTIONALLY_UNUSED( u16FunctionId );
    DIA_PARAMETER_INTENTIONALLY_UNUSED( roOutMsg );
    DIA_PARAMETER_INTENTIONALLY_UNUSED( poInMsg );
    return FALSE;
}

tBool
tclServiceDiaglibOneThread::bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error)
{
    // Diaglib does not offer any properties
    DIA_PARAMETER_INTENTIONALLY_UNUSED( poMessage );
    DIA_PARAMETER_INTENTIONALLY_UNUSED( bPropertyChanged );
    DIA_PARAMETER_INTENTIONALLY_UNUSED( u16Error );
    return FALSE;
}

tVoid
tclServiceDiaglibOneThread::vHandleAllMessages(amt_tclServiceData* poMessage)
{
   if( _poCcaIF == OSAL_NULL )
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceDiaglibOneThread::vHandleAllMessages => ERROR: OSAL_NULL == _poCcaIF "));
      return;
   }

   _poCcaIF->vDispatchMessage(poMessage);
}

tclSystemSetIF*
tclServiceDiaglibOneThread::poGetSysSet()
{
    return _poSysSetIF;

}

tclRoutineControlIF*
tclServiceDiaglibOneThread::poGetRoutineCtrl()
{
    return _poRoutineCtrlIF;

}

tclIoControlIF*
tclServiceDiaglibOneThread::poGetIoCtrl()
{
    return _poIoCtrlIF;

}

tclDiagnosisDataIF*
tclServiceDiaglibOneThread::poGetDiagData()
{
    return _poDiagDataIF;
}



}
