/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Service Handler CCA - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_CCA_SERVICE_HANDLER

#ifndef __INCLUDED_DIAGLIB_COMMON__
#define __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


// MIDW_FI DEFINES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS

// FI DEFINES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_IOCONTROL
#include "trcGenProj/Header/tclIoControlCCA.cpp.trc.h"
#endif

// If the Service ID is not defined in ccaservice.h use the default one
#ifndef CCA_C_U16_SRV_DIAGLIB
#define CCA_C_U16_SRV_DIAGLIB 0x0071
#endif

#include "tclCCAHelper.h"
#include "../Enumerations.h"
#include "tclServiceHandlerCCA.h"
#include "../tclMessageContextManager.h"
#include "tclMessageContextCCA.h"
#include "../tclIoControlListenerIF.h"
#include "../tclRoutineControlListenerIF.h"

#include "../Trace.h"

namespace diaglib {


/***********************************************************************//**
 * \brief Send routine control MethodResult Message
 *
 * Construct and send CCA message by doing the following steps:
 * \li Retrieve the message context using the provided Context pointer
 * \li Extract messaging data out of the MessageContext
 * \li Convert diaglib internal types to CCA specific midw_fi types
 * \li Put everything into a CCA message object
 * \li Send it using the application message send functionality
 * As there is no need to report success or failure on a finish message, only
 * the MessageContext handle is a parameter to this message.
 *
 * \param[in] enIoResult - Status of IO control request
 * \param[in] oRoutineResult - Result list of IO control or error code
 * \param[in] poMessageContext - MessageContext handle of incoming message
 *
 * \return  boolean if sending of response was successful or failed
 *//************************************************************************/
tBool tclServiceHandlerCCA::bSendIoCtrlMethodResult (
                                                         tenIoCtrlResult enIoResult, 
                                                         tenIoControlAction enAction, 
                                                         const tclParameterVector& oRoutineResult,
                                                         tContext context
                                                       )
{
   ETG_TRACE_COMP_THR(( "--> tclServiceHandlerCCA::bSendIoCtrlMethodResult"));

   midw_diaglibfi_tclMsgIOControlMethodResult oMethordResult;
   fi_tclVisitorMessage* poResultMsg = OSAL_NULL;

   tclMessageContextCCA* poMessageContextCca = OSAL_NULL;
   tBool bResult = TRUE;

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_GET_BACK_CTXT_FOR_HANDLE , static_cast<tU32>(context) );
   
   if( 
       tclMessageContextManager::bGetContextBack<tclMessageContextCCA>(context, &poMessageContextCca) == FALSE || 
       tclMessageContext::EN_MESSAGE_IO_CONTROL != poMessageContextCca->getMessageGroup() 
     )   
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_CANT_SEND_MSG_DUE_TO_CTXT);
      bResult = FALSE;
   }
   else
   {
      // Fill the CCA result message
      if(poMessageContextCca->u16GetFunctionId() == MIDW_DIAGLIBFI_C_U16_IOCONTROL)
      {
         oMethordResult.ControlId                  = poMessageContextCca->getId();
         oMethordResult.ActionId.enType            = static_cast<midw_fi_tcl_e8_IOControlActionId::tenType>(enAction);
         oMethordResult.IOResult.enType            = static_cast<midw_fi_tcl_e8_IOResult::tenType>(enIoResult);
         tclCCAHelper::vFillCcaValueListFromVector(oRoutineResult, oMethordResult.IOResultList );

         poResultMsg = OSAL_NEW fi_tclVisitorMessage( oMethordResult );
      }
      else
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendIoCtrlMethodResult => ERROR: u16GetFunctionId() != MIDW_DIAGLIBFI_C_U16_IOCONTROL"));
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_MSG_CONTEXT_ERROR);
         bResult = FALSE;
      }
      
      if(OSAL_NULL == poResultMsg)
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendIoCtrlMethodResult => ERROR: OSAL_NULL == poResultMsg"));
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_CANT_ALLOC_MEMORY_ON_HEAP);
         FATAL_M_ASSERT_ALWAYS();
         bResult = FALSE; // lint sucks
      }

      if(bResult == TRUE && poResultMsg != OSAL_NULL)
      {
         tclCCAHelper::vInitMethodResultServiceData((*poResultMsg), poMessageContextCca, u16OurAppId);

         DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_SENDING_MESSAGE_ID, poMessageContextCca->getId());
         DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_SENDING_MESSAGE_APPID, static_cast<tU32>(u16OurAppId));
         bResult = bSendMessage((*poResultMsg));
      }
      else
      {
         bResult = FALSE;
      }
   }

   if(OSAL_NULL != poResultMsg)
      OSAL_DELETE poResultMsg;

   if(OSAL_NULL != poMessageContextCca)
      OSAL_DELETE poMessageContextCca;
   

   ETG_TRACE_COMP_THR(( "<-- tclServiceHandlerCCA::bSendIoCtrlMethodResult"));
   return bResult;
}

/***********************************************************************//**
 * \brief Send routine control MethodResult Message
 *
 * Construct and send CCA message by doing the following steps:
 * \li Retrieve the message context using the provided Context pointer
 * \li Extract messaging data out of the MessageContext
 * \li Convert diaglib internal types to CCA specific midw_fi types
 * \li Put everything into a CCA message object
 * \li Send it using the application message send functionality
 * As there is no need to report success or failure on a finish message, only
 * the MessageContext handle is a parameter to this message.
 *
 * \param[in] enIoResult - Status of IO control request
 * \param[in] poMessageContext - MessageContext handle of incoming message
 *
 * \return  boolean if sending of response was successful or failed
 *//************************************************************************/
tBool tclServiceHandlerCCA::bSendIoCtrlFreezeResult (
                                                         tenIoCtrlResult enIoResult, 
                                                         tContext context
                                                       )
{
   ETG_TRACE_COMP_THR(( "--> tclServiceHandlerCCA::bSendIoCtrlFreezeResult"));

   midw_diaglibfi_tclMsgIOControlMethodResult oMethordResult;
   fi_tclVisitorMessage* poResultMsg = OSAL_NULL;

   tclMessageContextCCA* poMessageContextCca = OSAL_NULL;
   tBool bResult = TRUE;

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_GET_BACK_CTXT_FOR_HANDLE , static_cast<tU32>(context) );
   
   if( 
       tclMessageContextManager::bGetContextBack<tclMessageContextCCA>(context, &poMessageContextCca) == FALSE || 
       tclMessageContext::EN_MESSAGE_IO_CONTROL != poMessageContextCca->getMessageGroup() 
     )   
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_CANT_SEND_MSG_DUE_TO_CTXT);
      bResult = FALSE;
   }
   else
   {
      // Fill the CCA result message
      if(poMessageContextCca->u16GetFunctionId() == MIDW_DIAGLIBFI_C_U16_IOCONTROL)
      {
         oMethordResult.ControlId                  = poMessageContextCca->getId();
         oMethordResult.IOResult.enType            = static_cast<midw_fi_tcl_e8_IOResult::tenType>(enIoResult);
         oMethordResult.ActionId.enType            = static_cast<midw_fi_tcl_e8_IOControlActionId::tenType>(EN_ACTION_FREEZE);
         poResultMsg = OSAL_NEW fi_tclVisitorMessage( oMethordResult );
      }
      else
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendIoCtrlFreezeResult => ERROR: u16GetFunctionId() != MIDW_DIAGLIBFI_C_U16_IOCONTROL"));
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_MSG_CONTEXT_ERROR);
         bResult = FALSE;
      }
      
      if(OSAL_NULL == poResultMsg)
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendIoCtrlFreezeResult => ERROR: OSAL_NULL == poResultMsg"));
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_CANT_ALLOC_MEMORY_ON_HEAP);
         FATAL_M_ASSERT_ALWAYS();
         bResult = FALSE; // lint sucks
      }

      if(bResult == TRUE && poResultMsg != OSAL_NULL)
      {
         tclCCAHelper::vInitMethodResultServiceData((*poResultMsg), poMessageContextCca, u16OurAppId);

         DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_SENDING_MESSAGE_ID, poMessageContextCca->getId());
         DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_SENDING_MESSAGE_APPID, static_cast<tU32>(u16OurAppId));
         bResult = bSendMessage((*poResultMsg));
      }
      else
      {
         bResult = FALSE;
      }
   }

   if(OSAL_NULL != poResultMsg)
      OSAL_DELETE poResultMsg;

   if(OSAL_NULL != poMessageContextCca)
      OSAL_DELETE poMessageContextCca;
   

   ETG_TRACE_COMP_THR(( "<-- tclServiceHandlerCCA::bSendIoCtrlFreezeResult"));
   return bResult;
}

/***********************************************************************//**
 * \brief Send routine control MethodResult Message
 *
 * Construct and send CCA message by doing the following steps:
 * \li Retrieve the message context using the provided Context pointer
 * \li Extract messaging data out of the MessageContext
 * \li Convert diaglib internal types to CCA specific midw_fi types
 * \li Put everything into a CCA message object
 * \li Send it using the application message send functionality
 * As there is no need to report success or failure on a finish message, only
 * the MessageContext handle is a parameter to this message.
 *
 * \param[in] enIoResult - Status of IO control request
 * \param[in] poMessageContext - MessageContext handle of incoming message
 *
 * \return  boolean if sending of response was successful or failed
 *//************************************************************************/
tBool tclServiceHandlerCCA::bSendIoCtrlUnfreezeResult (
                                                         tenIoCtrlResult enIoResult, 
                                                         tContext context
                                                       )
{
   ETG_TRACE_COMP_THR(( "--> tclServiceHandlerCCA::bSendIoCtrlUnfreezeResult"));

   midw_diaglibfi_tclMsgIOControlMethodResult oMethordResult;
   fi_tclVisitorMessage* poResultMsg = OSAL_NULL;

   tclMessageContextCCA* poMessageContextCca = OSAL_NULL;
   tBool bResult = TRUE;

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_GET_BACK_CTXT_FOR_HANDLE , static_cast<tU32>(context) );
   
   if( 
       tclMessageContextManager::bGetContextBack<tclMessageContextCCA>(context, &poMessageContextCca) == FALSE || 
       tclMessageContext::EN_MESSAGE_IO_CONTROL != poMessageContextCca->getMessageGroup() 
     )   
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_CANT_SEND_MSG_DUE_TO_CTXT);
      bResult = FALSE;
   }
   else
   {
      // Fill the CCA result message
      if(poMessageContextCca->u16GetFunctionId() == MIDW_DIAGLIBFI_C_U16_IOCONTROL)
      {
         oMethordResult.ControlId                  = poMessageContextCca->getId();
         oMethordResult.IOResult.enType            = static_cast<midw_fi_tcl_e8_IOResult::tenType>(enIoResult);
         oMethordResult.ActionId.enType            = static_cast<midw_fi_tcl_e8_IOControlActionId::tenType>(EN_ACTION_UNFREEZE);
         poResultMsg = OSAL_NEW fi_tclVisitorMessage( oMethordResult );
      }
      else
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendIoCtrlUnfreezeResult => ERROR: u16GetFunctionId() != MIDW_DIAGLIBFI_C_U16_IOCONTROL"));
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_MSG_CONTEXT_ERROR);
         bResult = FALSE;
      }
      
      if(OSAL_NULL == poResultMsg)
      {
         ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::bSendIoCtrlUnfreezeResult => ERROR: OSAL_NULL == poResultMsg"));
         DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_IOCONTROL, E_DIAGLIB_CANT_ALLOC_MEMORY_ON_HEAP);
         FATAL_M_ASSERT_ALWAYS();
         bResult = FALSE; // lint sucks
      }

      if(bResult == TRUE && poResultMsg != OSAL_NULL)
      {
         tclCCAHelper::vInitMethodResultServiceData((*poResultMsg), poMessageContextCca, u16OurAppId);

         DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_SENDING_MESSAGE_ID, poMessageContextCca->getId());
         DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_SENDING_MESSAGE_APPID, static_cast<tU32>(u16OurAppId));
         bResult = bSendMessage((*poResultMsg));
      }
      else
      {
         bResult = FALSE;
      }
   }

   if(OSAL_NULL != poResultMsg)
      OSAL_DELETE poResultMsg;

   if(OSAL_NULL != poMessageContextCca)
      OSAL_DELETE poMessageContextCca;
   

   ETG_TRACE_COMP_THR(( "<-- tclServiceHandlerCCA::bSendIoCtrlUnfreezeResult"));
   return bResult;
}


/***********************************************************************//**
 * \brief Register the routine control listener
 *
 * Register the pointer to the diaglib INTERNAL listener for routine control
 * requests.
 *
 * \param[in] poListener - Pointer to Listener
 *
 * \return none
 *//************************************************************************/
tVoid tclServiceHandlerCCA::vRegisterIoControlListener ( 
                                                         tclIoControlListenerIF* poListener
                                                        )
{
   ETG_TRACE_COMP_THR(( "--> tclServiceHandlerCCA::vRegisterIoControlListener"));
   diaglib_FuncTrace fnctrc(I_DIAGLIB_F_REGISTER_IOCTRL_LISTENER);
   if(OSAL_NULL == poListener)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::vRegisterIoControlListener => ERROR: OSAL_NULL == poListener"));
   }
   else
   {
      poIoControlListener = poListener;
   }

   ETG_TRACE_COMP_THR(( "<-- tclServiceHandlerCCA::vRegisterIoControlListener"));

   
}

/***********************************************************************//**
 * \brief Handles incoming Routine Control messages
 *
 * On incoming request the following steps are executed
 * \li Check whether Message and registered listener are valid
 * \li On correct OpCode use midw_fi types to extract payload
 * \li Convert message payload to diaglib internal types
 * \li Create a message context to be able to send back a response
 * \li Call the registered listener using diaglib internal types
 *
 * \param[in] poMessage The incoming message
 *
 * \todo Implement!
 *
 * \return none
 *//************************************************************************/
tVoid tclServiceHandlerCCA::vHandleIOControl     ( amt_tclServiceData* poMessage )
{
   ETG_TRACE_COMP_THR(( "--> tclServiceHandlerCCA::vHandleIOControl"));
   //diaglib_FuncTrace fnctrc(I_DIAGLIB_F_HANDLE_IOCTRL);
   //DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_INCOMING_MESSAGE_ADV_START, static_cast<tU32>(u16OurAppId));
   ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::vHandleIOControl => ID= %d",static_cast<tU32>(u16OurAppId)));
   if(OSAL_NULL == poMessage)
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::vHandleIOControl => ERROR: OSAL_NULL == poMessage "));
      return;
   }
   else if(OSAL_NULL == poIoControlListener)
   {
      ETG_TRACE_ERR_THR(( "!!! tclServiceHandlerCCA::vHandleIOControl => ERROR: OSAL_NULL == poIoControlListener "));
      return;
   }

   tclMessageContextCCA* poMsgContext;
   tclParameterVector oParameters;
   oParameters.clear();   
   tContext context;

   switch (poMessage->u8GetOpCode())
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::vHandleIOControl => u8GetOpCode = AMT_C_U8_CCAMSG_OPCODE_METHODSTART"));
         midw_diaglibfi_tclMsgIOControlMethodStart oMsgData;

         // Create concrete msg object
         fi_tclVisitorMessage oMsg( poMessage );
         if (oMsg.s32GetData(oMsgData) == OSAL_ERROR)
         {
            NORMAL_M_ASSERT_ALWAYS ();
         }

         // Cast CCA types to internal types
         tclCCAHelper::vFillVectorFromCcaValueList(oMsgData.IOParameterList, oParameters);

         //DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_RECEIVED_MESSAGE_ID, oMsgData.ControlId);
         //DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_RECEIVED_MESSAGE_APPID, static_cast<tU32>(u16OurAppId));

         ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::vHandleIOControl => MessageId = %d",oMsgData.ControlId));
         ETG_TRACE_COMP_THR(( "--- tclServiceHandlerCCA::vHandleIOControl => AppId = %d", static_cast<tU32>(u16OurAppId)));
         // Create Message context and store it in MessageContext Manager
         poMsgContext = OSAL_NEW tclMessageContextCCA( 
                                                         poMessage, 
                                                         tclMessageContext::EN_MESSAGE_IO_CONTROL,
                                                         oMsgData.ControlId
                                                      );

         context = tclMessageContextManager::poAddContext(poMsgContext);

         switch((diaglib::tenIoControlAction)oMsgData.ActionId.enType)
         {
            case diaglib::EN_ACTION_FREEZE:
            {
               poIoControlListener->vOnIoControlFreeze(
                                                         oMsgData.ControlId,
                                                         context
                                                      );
               break;
            }// case diaglib::EN_ACTION_FREEZE:

            case diaglib::EN_ACTION_UNFREEZE:
            {
               poIoControlListener->vOnIoControlUnfreeze(
                                                            oMsgData.ControlId,
                                                            context
                                                         );
               break;
            }// case diaglib::EN_ACTION_UNFREEZE:

            case diaglib::EN_ACTION_SET:
            {
               poIoControlListener->vOnIoControl(
                                                   oMsgData.ControlId,
                                                   (diaglib::tenIoControlAction)oMsgData.ActionId.enType,
                                                   oParameters,
                                                   context
                                                );
               break;
            }// diaglib::EN_ACTION_SET:

            default:
            {
               NORMAL_M_ASSERT_ALWAYS ();
               break;
            }
         }// switch(enActionId)
         break;
      }

      default:
      {
         ETG_TRACE_COMP_THR(( "!!! tclServiceHandlerCCA::vHandleIOControl => ERROR: u8GetOpCode = default"));
         DIAGLIB_TRACE_WARN_U32(TR_CLASS_DIAGLIB_IOCONTROL, W_DIAGLIB_OPCODE_NOT_SUPPORTED , poMessage->u8GetOpCode() );
         vSendError ( poMessage, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
         break;
      }
   }// switch (poMessage->u8GetOpCode())

   DIAGLIB_TRACE_INFO_U32(TR_CLASS_DIAGLIB_IOCONTROL, I_DIAGLIB_INCOMING_MESSAGE_ADV_STOP, static_cast<tU32>(u16OurAppId));
   
   ETG_TRACE_COMP_THR(( "<-- tclServiceHandlerCCA::vHandleIOControl"));
   return;
}

}// namespace diaglib {
