/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief CCA Service Proxy - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_CCA_SERVICE_PROXY_H
#define DIAGLIB_CCA_SERVICE_PROXY_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

#include "../tclCCAServiceIF.h"

namespace diaglib {
class tclServiceHandlerCCA;
class tclInterfaceManager;

class tclCCAServiceProxy : public tclCCAServiceIF
{
   friend class tclInterfaceManager;

public:
// tclCCAServiceProxy(); // Not implemented, do not use
   tclCCAServiceProxy (
                                 tclServiceHandlerCCA* poServiceHandler,
                                 tclInterfaceManager* poResponsibleManager
                              ):
   poManager(poResponsibleManager), poServiceCCA(poServiceHandler) {}

   virtual tU16 u16GetServiceId();

   virtual tVoid vSetApplication(ail_tclIAppAdapt* poApp);

   virtual tVoid vDispatchMessage(amt_tclServiceData* poMessage);

   virtual tVoid vOnNewAppState(tU32 u32OldState, tU32 u32NewState);

   virtual tVoid vOnServiceState(tU16, tU16, tU16, tU8, tU16);

   virtual tclDiagnosisIF* poGetInterface(tenDiagHandlerInterfaces enInterfaceId);

   virtual tBool bGetServiceVersion ( tU16& rfu16MajorVersion,
                                      tU16& rfu16MinorVersion,
                                      tU16& rfu16PatchVersion);

protected:
   virtual ~tclCCAServiceProxy();
   tclCCAServiceProxy(): poManager(OSAL_NULL), poServiceCCA(OSAL_NULL) {}

protected:
   tclInterfaceManager* poManager;
   tclServiceHandlerCCA* poServiceCCA;
};
}
#endif // DIAGLIB_CCA_SERVICE_PROXY_H


