/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief CCA Service proxy - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif
#define DIAGLIB_FILE_NUMBER F_DIAGLIB_CCA_SERVICE_PROXY

#include "tclCCAServiceProxy.h"

#ifndef __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h" // use application help library
#endif

#include "../tclInterfaceManager.h"
#include "tclServiceHandlerCCA.h"

#include "../Trace.h"


// Todo, maybe implement the CCAServiceIF in the Service itself.

namespace diaglib {
/***********************************************************************//**
 * \brief Destructor
 *
 * Invalidates pointers. Does not OWN any objects.
 *
 * \return n/a
 *//************************************************************************/
tclCCAServiceProxy::~tclCCAServiceProxy()
{
   poServiceCCA = OSAL_NULL;
   poManager = OSAL_NULL;
}

/***********************************************************************//**
 * \brief Returns service ID of service
 *
 * Returns the internal Service ID, so application can dispatch messages
 *
 * \return tU16 ServiceID of internal service
 *//************************************************************************/
tU16 tclCCAServiceProxy::u16GetServiceId()
{
   if(OSAL_NULL == poServiceCCA)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return 0;
   }

   return poServiceCCA->u16GetServiceId();
}

/***********************************************************************//**
 * \brief Dispatches a message to the internal service.
 *
 * Calls the dispatch function of the internal service, that uses the AIL
 * framework to call the correct handler function in the service.
 *
 * \param[in] poMessage Message to dispatch
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAServiceProxy::vDispatchMessage(amt_tclServiceData* poMessage)
{
   if(OSAL_NULL == poServiceCCA)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return;
   }

   return poServiceCCA->vDispatchMessage(poMessage);
}

tVoid tclCCAServiceProxy::vSetApplication(ail_tclIAppAdapt* poApp)
{
   if(OSAL_NULL == poServiceCCA)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return;
   }

   return poServiceCCA->vSetApplication(poApp);
}

/***********************************************************************//**
 * \brief Applies new application state to internal service
 *
 * Calls the NewAppState on internal service
 *
 * \param[in] u32OldState Old application state
 * \param[in] u32NewState new application state to fulfil
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAServiceProxy::vOnNewAppState(tU32 u32OldState, tU32 u32NewState)
{
   if(OSAL_NULL == poServiceCCA)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return;
   }

   return poServiceCCA->vOnNewAppState(u32OldState, u32NewState);
}

/***********************************************************************//**
 * \brief Informs internal service of changed service state of other service
 *
 * This can never happen as the diaglib is not client to any other service.
 * And if it happens anyway, we are not intrested in it.
 *
 * \param[in] u16ParamX Bunch of unintresting parameters
 *
 * \todo maybe hardcoded instant return?
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAServiceProxy::vOnServiceState(tU16 u16Param1, tU16 u16Param2, tU16 u16Param3, tU8 u8Param4, tU16 u16Param5)
{
   if(OSAL_NULL == poServiceCCA)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return;
   }

   return poServiceCCA->vOnServiceState(u16Param1, u16Param2, u16Param3, u8Param4, u16Param5);
}

/***********************************************************************//**
 * \brief Returns the requested interface
 *
 * Delegates the request for an interface to the manager, as he is aware of
 * all interfaces.
 *
 * \param[in] enInterfaceId Interface ID
 *
 * \return tclDiagnosisIF* Pointer to requested interface. 
 *//************************************************************************/
tclDiagnosisIF* tclCCAServiceProxy::poGetInterface(tenDiagHandlerInterfaces enInterfaceId)
{
   if(OSAL_NULL == poManager)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return OSAL_NULL;
   }

   return poManager->poGetInterface(enInterfaceId);
}

tBool tclCCAServiceProxy::bGetServiceVersion ( tU16& rfu16MajorVersion, 
                                               tU16& rfu16MinorVersion, 
                                               tU16& rfu16PatchVersion)
{
   if(OSAL_NULL == poServiceCCA)
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return FALSE;
   }

   return poServiceCCA->bGetServiceVersion ( rfu16MajorVersion, 
                                             rfu16MinorVersion, 
                                             rfu16PatchVersion); 
}

}
