/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief CCA Helper - Diagnosis Library - Introduced in Ford MFD
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef DIAGLIB_CCA_HELPER_H
#define DIAGLIB_CCA_HELPER_H

#ifndef __INCLUDED_DIAGLIB_COMMON__
#include "../diaglib_common.h"
#endif

class fi_tclVisitorMessage;
class midw_fi_tcl_ValueList;
class midw_fi_tcl_ValueUnion;

#include "../Enumerations.h"     //lint !e537 Info 537 , eliminating lint warnings Repeated include file

namespace diaglib {

#define CONVERT_DIAGLIB_TO_CCA(midw_type, value, in_union, out_union) \
         midw_type* oVal = OSAL_NEW midw_type(); \
         if(OSAL_NULL == oVal) \
         { \
            DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_ROUTINECONTROL, E_DIAGLIB_CANT_ALLOC_MEMORY_ON_HEAP); \
            FATAL_M_ASSERT_ALWAYS(); \
            break; \
         } \
         oVal->value = in_union.value; \
         out_union = oVal;

class tclMessageContextCCA;

class tclCCAHelper
{
public:
   static tVoid vInitMethodResultServiceData (  fi_tclVisitorMessage& oMsg,
                                                const tclMessageContextCCA* poSourceContext,
                                                tU16 u16OurAppId
                                             );
   static tVoid vInitPrpertyStatusServiceData (  fi_tclVisitorMessage& oMsg,
                                                const tclMessageContextCCA* poSourceContext,
                                                tU16 u16OurAppId
                                             );

   static tVoid vFillCcaValueListFromVector( const tclParameterVector&, midw_fi_tcl_ValueList& );
   static tVoid vFillVectorFromCcaValueList( const midw_fi_tcl_ValueList&, tclParameterVector& );

   static tVoid vConvertCcaUnionToDiaglibUnion( const midw_fi_tcl_ValueUnion&, trParameter& );
   static tVoid vConvertDiaglibUnionToCcaUnion( const trParameter&, midw_fi_tcl_ValueUnion& );
};

}

#endif
