/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief Service Handler CCA - Diagnosis Library - Introduced in MFD Nav
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/

#ifdef DIAGLIB_FILE_NUMBER
#undef DIAGLIB_FILE_NUMBER
#endif

#include "tclCCAHelper.h"

#define DIAGLIB_FILE_NUMBER F_DIAGLIB_CCA_HELPER

#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif


// MIDW_FI DEFINES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS

// FI DEFINES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//#define CCA_S_IMPORT_INTERFACE_GENERIC
//#include "cca_if.h"

//#include "../Enumerations.h"
//#include "tclServiceHandlerCCA.h"
#include "tclMessageContextCCA.h"

#include "../Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ET_DIAGLIB_GENERAL
#include "trcGenProj/Header/tclCCAHelper.cpp.trc.h"
#endif


namespace diaglib {

/***********************************************************************//**
 * \brief Fills a response message with data from the MessageContext
 *
 * Uses the provided message context to fill in the service data of the 
 * provided VisitioMessage class.
 * 
 * \param[out] oMsg VisitorMessage to be filled with data
 * \param[in] poSourceContext MessageContext containing the service data
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAHelper::vInitMethodResultServiceData (fi_tclVisitorMessage& oMsg, const tclMessageContextCCA* poSourceContext, tU16 u16OurAppId)
{
   diaglib_FuncTrace oTrace(I_DIAGLIB_F_INIT_MR_SERVICE_DATA);

   if ( NULL == poSourceContext )
   {
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return;
   }

   oMsg.vInitServiceData (
                           u16OurAppId,
                           poSourceContext->u16GetSenderAppId(),
                           AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                           0,
                           poSourceContext->u16GetRegisterId(),
                           poSourceContext->u16GetCmdCounter(),
                           poSourceContext->u16GetServiceId(),
                           poSourceContext->u16GetFunctionId(),
                           AMT_C_U8_CCAMSG_OPCODE_METHODRESULT
                         );

   
}

/***********************************************************************//**
 * \brief Fills a response message with data from the MessageContext
 *
 * Uses the provided message context to fill in the service data of the 
 * provided VisitioMessage class.
 * 
 * \param[out] oMsg VisitorMessage to be filled with data
 * \param[in] poSourceContext MessageContext containing the service data
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAHelper::vInitPrpertyStatusServiceData (fi_tclVisitorMessage& oMsg, const tclMessageContextCCA* poSourceContext, tU16 u16OurAppId)
{
   ETG_TRACE_COMP_THR(("--> tclCCAHelper::vInitPrpertyStatusServiceData"));

   if ( NULL == poSourceContext )
   {
      ETG_TRACE_ERR_THR(( "!!! tclCCAHelper::vInitPrpertyStatusServiceData => ERROR: NULL == poSourceContext"));
      DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_GENERAL, E_DIAGLIB_UNEXPECTED_NULLPOINTER);
      return;
   }

   oMsg.vInitServiceData (
                           u16OurAppId,
                           poSourceContext->u16GetSenderAppId(),
                           AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                           0,
                           poSourceContext->u16GetRegisterId(),
                           poSourceContext->u16GetCmdCounter(),
                           poSourceContext->u16GetServiceId(),
                           poSourceContext->u16GetFunctionId(),
                           AMT_C_U8_CCAMSG_OPCODE_STATUS
                         );

   ETG_TRACE_COMP_THR(("<-- tclCCAHelper::vInitPrpertyStatusServiceData"));
  
}
/***********************************************************************//**
 * \brief Fills a midw_fi value list from a diaglib internal vector
 *
 * Transforms the ParameterVector which is the diaglib internal type for 
 * variable value lists into the midw_fi type representing a ValueList.
 * 
 * \param[in] oVector Source vector
 * \param[out] oValueList Target value list
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAHelper::vFillCcaValueListFromVector(const tclParameterVector& oVector, midw_fi_tcl_ValueList& oValueList)
{
   ETG_TRACE_USR3_THR(("--> tclCCAHelper::vFillCcaValueListFromVector"));
   const tU32 u32Size = static_cast<tU32>( oVector.size() );

   if( static_cast<tU32>(oValueList.ValueList.size()) != 0 )
   {
      ETG_TRACE_ERR_THR(( "!!! tclCCAHelper::vFillCcaValueListFromVector => ERROR: oValueList.ValueList.size != 0"));
      return;
   }

   ETG_TRACE_USR4_THR(( "--- tclCCAHelper::vFillCcaValueListFromVector => Size = %d",u32Size));
   for ( tU32 i = 0; i < u32Size; ++i )
   {
      midw_fi_tcl_ValueUnion oValueUnion;

      vConvertDiaglibUnionToCcaUnion(oVector[i], oValueUnion);

      oValueList.ValueList.push_back(oValueUnion);
   }

   ETG_TRACE_USR3_THR(("<-- tclCCAHelper::vFillCcaValueListFromVector"));
}

/***********************************************************************//**
 * \brief Fills a midw_fi value list from a diaglib internal vector
 *
 * Transforms the ParameterVector which is the diaglib internal type for 
 * variable value lists into the midw_fi type representing a ValueList.
 * 
 * \param[in] oVector Source vector
 * \param[out] oValueList Target value list
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAHelper::vFillVectorFromCcaValueList(const midw_fi_tcl_ValueList& oValueList, tclParameterVector& oVector)
{
   ETG_TRACE_USR3_THR(("--> tclCCAHelper::vFillVectorFromCcaValueList"));

   const tU32 u32Size = static_cast<tU32>(oValueList.ValueList.size());
   trParameter rParameter;
   if( static_cast<tU32>(oVector.size()) != 0 )
   {
      ETG_TRACE_ERR_THR(("!!! tclCCAHelper::vFillVectorFromCcaValueList => oValueList.ValueList.size != 0"));
      return;
   }

   ETG_TRACE_USR4_THR(( "--- tclCCAHelper::vFillVectorFromCcaValueList => Size = %d",u32Size));
   for ( tU32 i = 0; i < u32Size; ++i )
   {
      vConvertCcaUnionToDiaglibUnion(oValueList.ValueList[i], rParameter);

      oVector.push_back(rParameter);
   }
   ETG_TRACE_USR3_THR(("<-- tclCCAHelper::vFillVectorFromCcaValueList"));
   
}

/***********************************************************************//**
 * \brief Converts a midw_fi union to a diaglib internal union
 *
 * See brief. This is a helper function to the function that converts whole
 * ValueLists (containing midw_fi unions) to Vectors (containing int. unions)
 * 
 * \param[in] oCcaIn Source CCA union in
 * \param[out] oDiagLibOut Target diaglib union out
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAHelper::vConvertCcaUnionToDiaglibUnion( const midw_fi_tcl_ValueUnion& oCcaIn, trParameter& oDiagLibOut )
{
   ETG_TRACE_COMP_THR(("--> tclCCAHelper::vConvertCcaUnionToDiaglibUnion"));
   tU8 u8Type = static_cast<tU8>(oCcaIn.ValueUnionType.enType);
   oDiagLibOut.enType = static_cast<tenParameterType>(u8Type);

   // Lint 1774 -> Dynamic casts or other Runtime Type Information usage not allowed by programming guidelines
   switch(oDiagLibOut.enType)
   {
      case EN_PARAMETER_TYPE_BOOL:
      {
         oDiagLibOut.bValue = (static_cast<midw_fi_tclBool*>(oCcaIn.poValueUnionData))->bValue; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_U8:
      {
         oDiagLibOut.u8Value = (static_cast<midw_fi_tclU8*>(oCcaIn.poValueUnionData))->u8Value; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_U16:
      {
         oDiagLibOut.u16Value = (static_cast<midw_fi_tclU16*>(oCcaIn.poValueUnionData))->u16Value; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_U32:
      {
         oDiagLibOut.u32Value = (static_cast<midw_fi_tclU32*>(oCcaIn.poValueUnionData))->u32Value; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_S8:
      {
         oDiagLibOut.s8Value = (static_cast<midw_fi_tclS8*>(oCcaIn.poValueUnionData))->s8Value; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_S16:
      {
         oDiagLibOut.s16Value = (static_cast<midw_fi_tclS16*>(oCcaIn.poValueUnionData))->s16Value; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_S32:
      {
         oDiagLibOut.s32Value = (static_cast<midw_fi_tclS32*>(oCcaIn.poValueUnionData))->s32Value; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_F32:
      {
         oDiagLibOut.f32Value = (static_cast<midw_fi_tclF32*>(oCcaIn.poValueUnionData))->f32Value; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_F64:
      {
         oDiagLibOut.f64Value = (static_cast<midw_fi_tclF64*>(oCcaIn.poValueUnionData))->f64Value; //lint !e1774
         break;
      }
      case EN_PARAMETER_TYPE_U8ERROR:
      {
         midw_fi_tcl_e8_InternalError::tenType enType;
         tU8 u8ErrorType;

         enType = static_cast<midw_fi_tcl_e8_InternalError*>(oCcaIn.poValueUnionData)->enType; //lint !e1774
         u8ErrorType = static_cast<tU8>(enType);

         oDiagLibOut.u8ErrorValue = static_cast<tenInternalError>(u8ErrorType);
         break;
      }
      case EN_PARAMETER_TYPE_ARRAY_U8:
      {
         oDiagLibOut.u8Value = (static_cast<midw_fi_tclU8*>(oCcaIn.poValueUnionData))->u8Value; //lint !e1774 Info: could use dynamic_cast to downcast polymorphic type; But we compile with --nortti option
         break;
      }
      default:
      {
         ETG_TRACE_ERR_THR(("!!! tclCCAHelper::vConvertCcaUnionToDiaglibUnion => ERROR: UNKNOWN ID %d",oDiagLibOut.enType));
         break;
      }
   }
    ETG_TRACE_COMP_THR(("<-- tclCCAHelper::vConvertCcaUnionToDiaglibUnion"));  
}

/***********************************************************************//**
 * \brief Converts a diaglib internal union to a midw_fi union
 *
 * See brief. This is a helper function to the function which converts whole
 * Vectors (containing int. unions) to ValueLists (containing midw_fi unions)
 * 
 * \param[in] oDiagLibIn Source diaglib union in
 * \param[out] oCcaOut Target CCA union out
 *
 * \return none
 *//************************************************************************/
tVoid tclCCAHelper::vConvertDiaglibUnionToCcaUnion( const trParameter& oDiagLibIn, midw_fi_tcl_ValueUnion& oCcaOut )
{
    ETG_TRACE_COMP_THR(("--> tclCCAHelper::vConvertDiaglibUnionToCcaUnion"));  
   tU8 u8Type = static_cast<tU8>(oDiagLibIn.enType);
   oCcaOut.ValueUnionType.enType = static_cast<midw_fi_tcl_e8_ValueType::tenType>(u8Type);

   switch(oDiagLibIn.enType)
   {
      case EN_PARAMETER_TYPE_BOOL:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclBool, bValue, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_U8:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclU8, u8Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_U16:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclU16, u16Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_U32:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclU32, u32Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_S8:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclS8, s8Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_S16:
      {  
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclS16, s16Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_S32:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclS32, s32Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_F32:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclF32, f32Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_F64:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclF64, f64Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      case EN_PARAMETER_TYPE_U8ERROR:
      {
         tU32 u32MediatorValue;
         midw_fi_tcl_e8_InternalError* oVal = OSAL_NEW midw_fi_tcl_e8_InternalError();
         if(OSAL_NULL == oVal)
         {
            DIAGLIB_TRACE_ERROR(TR_CLASS_DIAGLIB_ROUTINECONTROL, E_DIAGLIB_CANT_ALLOC_MEMORY_ON_HEAP);
            FATAL_M_ASSERT_ALWAYS();
            break; // Not reachable, but lint doesn't now that
         }

         u32MediatorValue = static_cast<tU32>(oDiagLibIn.u8ErrorValue);
         oVal->enType = static_cast<midw_fi_tcl_e8_InternalError::tenType>(u32MediatorValue);

         oCcaOut.poValueUnionData = oVal;
         break;
      }
      case EN_PARAMETER_TYPE_ARRAY_U8:
      {
         CONVERT_DIAGLIB_TO_CCA(midw_fi_tclU8, u8Value, oDiagLibIn, oCcaOut.poValueUnionData);
         break;
      }
      default:
      {
         ETG_TRACE_ERR_THR(("!!! tclCCAHelper::vConvertDiaglibUnionToCcaUnion => ERROR: UNKNOWN ID %d",oDiagLibIn.enType));
         break;
      }
   }
   ETG_TRACE_COMP_THR(("<-- tclCCAHelper::vConvertDiaglibUnionToCcaUnion"));  
}

}// namespace diaglib {
