/************************************************************************
* FILE:         dia_KDSEntryLength.h
* PROJECT:      Vag
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: KDS Entry Length, and KDS Type Definitions
*
*----------------------------------------------------------------------
* COPYRIGHT:  (c) 2007 Robert Bosch GmbH, Hildesheim
*************************************************************************/

#ifndef DIA_KDSENTRYLENGTH_H
#define DIA_KDSENTRYLENGTH_H

#ifndef __INCLUDED_DIA_EXTERN_SYSTEM_PIF_KDS__
#define __INCLUDED_DIA_EXTERN_SYSTEM_PIF_KDS__ //lint !e750 local macro not referenced
#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF      //lint !e451 header file repeatedly included but does not have a standard include guard
#include "system_pif.h"
#endif

/**********************************************************************/
/* : KDS Entry Length                                                 */
/**********************************************************************/

// : Type No
#define KDS_PRODRELDATA_TYPENO_ENLENG            10
// : Serial Number
#define KDS_PRODRELDATA_ALPHANUMSLNO_ENLENG      14
// : Prod Date
#define KDS_PRODRELDATA_PRODDATE_ENLENG          6
// : Prod Shift
#define KDS_PRODRELDATA_PRODSHIFT_ENLENG         1
// : Count Checks
#define KDS_PRODRELDATA_COUNTOFCHECKS_ENLENG     2
// : Count Failure
#define KDS_PRODRELDATA_COUNTOFFAILURE_ENLENG    2
// : Kind Failure
#define KDS_PRODRELDATA_KINDOFLASTFAILURE_ENLENG 3
// : Count Repairs
#define KDS_PRODRELDATA_COUNTOFREPAIRS_ENLENG    2   
// : Kind Repairs
#define KDS_PRODRELDATA_KINDOFLASTREPAIR_ENLENG  3   
// : Serial No
#define KDS_PRODRELDATA_SLNO_ENLENG              7
// : Module Number
#define KDS_PRODRELDATA_MODULENO_ENLENG          2
// : Prod Change Val
#define KDS_PRODRELDATA_PRODCHANGEVALUE_ENLENG   8
// : Prod Line
#define KDS_PRODRELDATA_PRODLINE_ENLENG          2

#define KDS_PRODRELDATA_CUSTDIAGPROTOCOLTYPE_ENLENG 1




//Customer Related ECU PART NO ID PREFIX (FORD) (KDS - KDS_TYPE_END_MODEL_PART_NUMBER)
#define KDS_CUSTRELDATA_ECUPARTNOIDPREFIX_ENLENG 4
//Customer Related ECU PART NO BASE (FORD) (KDS - KDS_TYPE_BASE_MODEL_PART_NUMBER)
#define KDS_CUSTRELDATA_ECUPARTNOBASE_ENLENG     4
//Customer Related ECU PART NO ID SUFFIX (FORD) (KDS - KDS_TYPE_END_MODEL_PART_NUMBER_ALPHA_CODE)
#define KDS_CUSTRELDATA_ECUPARTNOIDSUFFIX_ENLENG 2
//Customer Related ECU RNS SL NO - 1 (FORD) (KDS - KDS_TYPE_SERIAL_NUMBER)
#define KDS_CUSTRELDATA_RNSSLNO1_ENLENG          4
//Customer Related ECU RNS SL NO - 2 (FORD) (KDS - KDS_TYPE_SERIAL_NUMBER_ALPHANUM)
#define KDS_CUSTRELDATA_RNSSLNO2_ENLENG          4



#define KDS_CUSTRELDATA_SYSSUPPLIERID_ENLENG     9
#define KDS_CUSTRELDATA_PROGRAMMINGDATE_ENLENG   4
#define KDS_CUSTRELDATA_NAVISWVERSION_ENLENG     5
#define KDS_CUSTRELDATA_MTC_ENLENG               16
#define KDS_CUSTRELDATA_MCUSWVERSION_ENLENG      2
#define KDS_CUSTRELDATA_GMSERIALDATADBREVLEVEL_ENLENG 2
#define KDS_CUSTRELDATA_ENDMODELPARTNO_ENLENG    4
#define KDS_CUSTRELDATA_ECUDIAGADDR_ENLENG       1
#define KDS_CUSTRELDATA_BASEMODELPARTNO_ENLENG   4
#define KDS_CUSTRELDATA_DDI_ENLENG               2
#define KDS_CUSTRELDATA_ECUCODEVERSION_ENLENG    6
#define KDS_CUSTRELDATA_SEED_ENLENG              2
#define KDS_CUSTRELDATA_KEY_ENLENG               2
#define KDS_CUSTRELDATA_VMECUSWNO_ENLENG         24
#define KDS_CUSTRELDATA_VMECUHWNO_ENLENG         24
#define KDS_CUSTRELDATA_ECUDELASSNO_ENLENG       24
#define KDS_CUSTRELDATA_ECUCOREASSNR_ENLENG      24
#define KDS_CUSTRELDATA_DIADBREFNO_ENLENG        24
#define KDS_CUSTRELDATA_SPEEDLOCK_ENLENG         2
#define KDS_CUSTRELDATA_MANFDATA_ENLENG          5
#define KDS_CUSTRELDATA_LOGGINGENABLE_ENLENG     1


#define KDS_CUSTRELDATA_VIN_ENLENG               17
#define KDS_CUSTRELDATA_HINACU_ENLENG            3
#define KDS_CUSTRELDATA_CCB_ENLENG               21
#define KDS_CUSTRELDATA_CSE_ENLENG               36
#define KDS_CUSTRELDATA_CSTD_ENLENG              3
#define KDS_CUSTRELDATA_SWNO3PARTNO_ENLENG       24
#define KDS_CUSTRELDATA_AUD_VOLUME_ENLENG        1

#define KDS_CUSTRELDATA_DIMMING_DELAY_ENLENG     4
#define KDS_CUSTRELDATA_DIMMING_TEMP_ENLENG      2
#define KDS_CUSTRELDATA_DIMMING_PWM_ENLENG       2

#define KDS_CUSTRELDATA_HEATCTRL_TEMP_ENLENG     2

//KDS data Length define for ADC Calibration Value
#define KDS_KON_ADC_CALIBRATION_ENGLEN          4


#define KDS_PRODRELDATA_MAX_ENLENG               0xff

//	: Hardware Version
#define KDS_HWVERSION_ENLENG                     6
//	: Hardware Version
#define KDS_SWVERSION_ENLENG                     6
//	: Burn In Mode
#define KDS_SYSCONTROL_BURNINMODE_ENLENG         1

#define KDSTESTREAD_OFFSET                       4
#define KDSTESTWRITE_OFFSET                      4

#define KDS_CUSTRELDATA_MANENCOUNTER_ENLENG      1

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAG_VAG
// for info: from system_kds_def.h, 13Jun07
// #define KDS_TYPE_CUST_DATA_PROJECT                   (0xCA)  /* Diag Customer Data - project specific */

#define DIA_KDS_TYPE_CONFIG_BLOCK                (KDS_TYPE_CUST_DATA_PROJECT + 0)
#define DIA_KDS_TYPE_FORD_VIN                    (KDS_TYPE_CUST_DATA_PROJECT + 1)
#define DIA_KDS_TYPE_HINACU                      (KDS_TYPE_CUST_DATA_PROJECT + 2)
#define DIA_KDS_TYPE_CAR_SPEC_EQU                (KDS_TYPE_CUST_DATA_PROJECT + 3)
#define DIA_KDS_TYPE_CAR_SPEC_TIME_DELAY         (KDS_TYPE_CUST_DATA_PROJECT + 4)
#define DIA_KDS_TYPE_VMECUSWNO                   (KDS_TYPE_CUST_DATA_PROJECT + 5)
#define DIA_KDS_TYPE_VMECUHWNO                   (KDS_TYPE_CUST_DATA_PROJECT + 6)
#define DIA_KDS_TYPE_ECUDELASSNO                 (KDS_TYPE_CUST_DATA_PROJECT + 7)
#define DIA_KDS_TYPE_DIADBREFNO                  (KDS_TYPE_CUST_DATA_PROJECT + 8)
#define DIA_KDS_TYPE_SWNO3PARTNO                 (KDS_TYPE_CUST_DATA_PROJECT + 9)

#endif

#endif
