#ifndef __INCLUDED_DIA_KDSENTRIES__
#define __INCLUDED_DIA_KDSENTRIES__

#ifndef __INCLUDED_DIA_EXTERN_SYSTEM_PIF_KDS__
#define __INCLUDED_DIA_EXTERN_SYSTEM_PIF_KDS__ //lint !e750 local macro not referenced
#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#include "system_pif.h" //lint !e451 !e537 header file repeatedly included but does not have a standard include guard
#endif

// KDS target types used for diagnosis
#define DIA_C_KDS_TARGET_DEVICE                       ((tU8) KDS_TARGET_DEVICE)
#define DIA_C_KDS_TARGET_CUSTOMER                     ((tU8) KDS_TARGET_CUSTOMER)
#define DIA_C_KDS_TARGET_PRODUCTION                   ((tU8) KDS_TARGET_PRODUCTION)

#define DIA_C_KDS_DEVICE_BASE                         ((tU8) 0x00)
#define DIA_C_KDS_CUSTOMER_BASE                       ((tU8) (0xCA + 9))
#define DIA_C_KDS_PRODUCTION_BASE                     ((tU8) 0x00)
#define DIA_C_KDS_CUSTOMER_BASE_NI                    ((tU8) 0x00)

// create the 2 byte KDS identifier
#define DIA_M_KDS_ENTRY(target,type)                  ((tU16)(((target)<<8) + ((tU8)(type))))

////////////////////////////////////////////////////////////////////////////////
//
// The identifiers specified here are VW specific
//
////////////////////////////////////////////////////////////////////////////////

// Identification
#define DIA_C_U16_KDS_SYSINFO                       DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF4) // DIA_C_KDS_CUSTOMER_BASE + 33)
#define DIA_C_U16_KDS_OEM_TYPE                      DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF4) // DIA_C_KDS_CUSTOMER_BASE + 33)
#define DIA_C_U16_KDS_CM_CONFIG_STRING              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF4) // DIA_C_KDS_CUSTOMER_BASE + 33)

#define DIA_C_U16_KDS_ECU_SERIAL_NUM                DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF0) // DIA_C_KDS_CUSTOMER_BASE + 29)
#define DIA_C_U16_KDS_ECU_SUPPLIER_NUM              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF1) // DIA_C_KDS_CUSTOMER_BASE + 30)
#define DIA_C_U16_KDS_ECU_MANUFACTURING_DATE        DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF2) // DIA_C_KDS_CUSTOMER_BASE + 31)
#define DIA_C_U16_KDS_ECU_PROD_TEST_SYSTEM_NUM      DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF3) // DIA_C_KDS_CUSTOMER_BASE + 32)

#define DIA_C_U16_KDS_ODX_FILE_ID                   DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD4) // DIA_C_KDS_CUSTOMER_BASE +  1)
#define DIA_C_U16_KDS_ODX_FILE_VERSION              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD5) // DIA_C_KDS_CUSTOMER_BASE +  2)
#define DIA_C_U16_KDS_SYSNAME_OR_ENGINETYPE         DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD6) // DIA_C_KDS_CUSTOMER_BASE +  3)

#define DIA_C_U16_KDS_VW_ECU_HW_NUM                 DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD7) // DIA_C_KDS_CUSTOMER_BASE +  4)
#define DIA_C_U16_KDS_VW_ECU_HW_VERSION_NUM         DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD8) // DIA_C_KDS_CUSTOMER_BASE +  5)
#define DIA_C_U16_KDS_VW_ECU_SW_VERSION_NUM         DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD9) // DIA_C_KDS_CUSTOMER_BASE +  6)
#define DIA_C_U16_KDS_VW_SPARE_PART_NUM             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xDA) // DIA_C_KDS_CUSTOMER_BASE +  7)
#define DIA_C_U16_KDS_VW_SUPPLIER_NUM               DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xDB) // DIA_C_KDS_CUSTOMER_BASE +  8)
#define DIA_C_U16_KDS_VW_SUPPLIER_PLANT             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xDC) // DIA_C_KDS_CUSTOMER_BASE +  9)
#define DIA_C_U16_KDS_VW_WORKSHOP_SYSTEM_NAME       DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xDD) // DIA_C_KDS_CUSTOMER_BASE + 10)

// Coding
#define DIA_C_U16_KDS_CALIBRATION_DATE              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xDE) // DIA_C_KDS_CUSTOMER_BASE + 11)
#define DIA_C_U16_KDS_CALIBRATION_FINGERPRINT       DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xDF) // DIA_C_KDS_CUSTOMER_BASE + 12)
#define DIA_C_U16_KDS_CODING_DATE                   DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE0) // DIA_C_KDS_CUSTOMER_BASE + 13)
#define DIA_C_U16_KDS_CODING_FINGERPRINT            DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE1) // DIA_C_KDS_CUSTOMER_BASE + 14)
#define DIA_C_U16_KDS_CODING_VALUE                  DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE2) // DIA_C_KDS_CUSTOMER_BASE + 15)
#define DIA_C_U16_KDS_CODING_VALUE_MIRROR           DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF7) // DIA_C_KDS_CUSTOMER_BASE + 36)

// Calibration
#define DIA_C_U16_KDS_EJECT_LOCK_MODE               DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE3) // DIA_C_KDS_CUSTOMER_BASE + 16)
#define DIA_C_U16_KDS_ENG_TEST_MODE                 DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE4) // DIA_C_KDS_CUSTOMER_BASE + 17)
#define DIA_C_U16_KDS_TEMP_ENG_TEST_MODE            DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE5) // DIA_C_KDS_CUSTOMER_BASE + 18)
#define DIA_C_U16_KDS_DEST_ENTRY_SPEED_LIMIT        DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE6) // DIA_C_KDS_CUSTOMER_BASE + 19)
#define DIA_C_U16_KDS_PHONE_BASE_VOLUME_LEVEL       DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE7) // DIA_C_KDS_CUSTOMER_BASE + 20)
#define DIA_C_U16_KDS_PHONE_CRADLE_TYPE             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE8) // DIA_C_KDS_CUSTOMER_BASE + 21)
#define DIA_C_U16_KDS_PHONE_INTERNAL_DSP_MODE       DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xE9) // DIA_C_KDS_CUSTOMER_BASE + 22)
#define DIA_C_U16_KDS_PHONE_VOICE_CTRL_MODE         DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xEA) // DIA_C_KDS_CUSTOMER_BASE + 23)
#define DIA_C_U16_KDS_PHONE_INFO_CALL_NUM           DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xEB) // DIA_C_KDS_CUSTOMER_BASE + 24)
#define DIA_C_U16_KDS_PHONE_BREAKDOWN_CALL_NUM      DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xEC) // DIA_C_KDS_CUSTOMER_BASE + 25)
#define DIA_C_U16_KDS_COUNTRY_OF_SALE_ID            DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xED) // DIA_C_KDS_CUSTOMER_BASE + 26)
#define DIA_C_U16_KDS_MICROPHONE_SENSITIVITY        DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xEE) // DIA_C_KDS_CUSTOMER_BASE + 27)
#define DIA_C_U16_KDS_REF_CHANNEL_DELAY             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xEF) // DIA_C_KDS_CUSTOMER_BASE + 28)
#define DIA_C_U16_KDS_DIMMING_DEFAULT               DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF9) // DIA_C_KDS_CUSTOMER_BASE + 38) // 0DF9
#define DIA_C_U16_KDS_HMI_LANGUAGE                  DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xFD) // DIA_C_KDS_CUSTOMER_BASE + 42)
#define DIA_C_U16_KDS_BLUETOOTH_DEVICE_NAME         DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xFE) // DIA_C_KDS_CUSTOMER_BASE + 43) // 0DFE
#define DIA_C_U16_KDS_DISP_TEXT_OUTPUT_LIMITATION   DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xFF) //DIA_C_KDS_CUSTOMER_BASE + 44) // 0DFF
#define DIA_C_U16_KDS_TOUCH_PANAL                   DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD3)

#define DIA_C_U16_KDS_RDS_ACTIVATION				DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xF8) // DIA_C_KDS_CUSTOMER_BASE + 37) // 0DF8

#define DIA_C_U16_KDS_MICROPHONE_THRESHOLDS         DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x30) // DIA_C_KDS_CUSTOMER_BASE + 27)

// OPEL
#define DIA_C_U16_KDS_OPEL_DIA_DATA_ID              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x21)
#define DIA_C_U16_KDS_OPEL_DIA_DATA_ADDR            DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x22)
#define DIA_C_U16_KDS_OPEL_SYS_SUPPLIER_ID          DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x23)
#define DIA_C_U16_KDS_OPEL_PROD_DATE_AT_SUPPLIER    DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x24)
#define DIA_C_U16_KDS_OPEL_END_MODEL_PART_NUMBER    DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xFA) // DIA_C_KDS_CUSTOMER_BASE + 39
#define DIA_C_U16_KDS_OPEL_SW_CONTENT_NUMBER        DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD9) // 0xFB) // DIA_C_KDS_CUSTOMER_BASE + 40
#define DIA_C_U16_KDS_OPEL_MTC                      DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xFC) // DIA_C_KDS_CUSTOMER_BASE + 41

// Nissan LCN2
#define DIA_C_U16_KDS_NISSAN_SYSTEM_IDENTIFICATION  DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0xFC) // DIA_C_KDS_CUSTOMER_BASE + 41

#define DIA_C_U16_KDS_NISSAN_BTNAME 				DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0xFE) // Changed to match VW RNS315
#define DIA_C_U16_KDS_NISSAN_SYSTEM_CONFIG			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x52)
#define DIA_C_U16_KDS_NISSAN_SYSTEM_CONFIG2			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x53)
#define DIA_C_U16_KDS_NISSAN_VEHICLE_INFO			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x59)
#define DIA_C_U16_KDS_NISSAN_HANDS_FREE1			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x5a)
#define DIA_C_U16_KDS_NISSAN_HANDS_FREE2			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x62)
#define DIA_C_U16_KDS_NISSAN_TELEMATIC_PARAM_SET1	DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x5b)
#define DIA_C_U16_KDS_NISSAN_TELEMATIC_PARAM_SET2	DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x5c)
#define DIA_C_U16_KDS_NISSAN_FMAMTUNER_PARAM_SET	DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x5d)
#define DIA_C_U16_KDS_NISSAN_PARTS_NUMBER			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x5e)
#define DIA_C_U16_KDS_NISSAN_AUDIO_PARAM_SET		DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x5f)
#define DIA_C_U16_KDS_NISSAN_ECOROUTE				DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x60)
#define DIA_C_U16_KDS_NISSAN_CAMERA_SYSTEM			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x61)
#define DIA_C_U16_KDS_NISSAN_DAB_PARAM_SET1	        DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x62)
#define DIA_C_U16_KDS_NISSAN_DAB_PARAM_SET2	        DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x63)

// default config
#define DIA_C_U16_KDS_NISSAN_DEF_BTNAME 				DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x70) 
#define DIA_C_U16_KDS_NISSAN_DEF_SYSTEM_CONFIG			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x71)
#define DIA_C_U16_KDS_NISSAN_DEF_SYSTEM_CONFIG2			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x72)
#define DIA_C_U16_KDS_NISSAN_DEF_VEHICLE_INFO			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x73)
#define DIA_C_U16_KDS_NISSAN_DEF_HANDS_FREE1			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x74)
#define DIA_C_U16_KDS_NISSAN_DEF_HANDS_FREE2			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x75)
#define DIA_C_U16_KDS_NISSAN_DEF_TELEMATIC_PARAM_SET1	DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x76)
#define DIA_C_U16_KDS_NISSAN_DEF_TELEMATIC_PARAM_SET2	DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x77)
#define DIA_C_U16_KDS_NISSAN_DEF_FMAMTUNER_PARAM_SET	DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x78)
#define DIA_C_U16_KDS_NISSAN_DEF_PARTS_NUMBER			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x79)
#define DIA_C_U16_KDS_NISSAN_DEF_AUDIO_PARAM_SET		DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x7a)
#define DIA_C_U16_KDS_NISSAN_DEF_ECOROUTE				DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x7b)
#define DIA_C_U16_KDS_NISSAN_DEF_CAMERA_SYSTEM			DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x7c)
#define DIA_C_U16_KDS_NISSAN_DEF_DAB_PARAM_SET1	        DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x7d)
#define DIA_C_U16_KDS_NISSAN_DEF_DAB_PARAM_SET2	        DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0x7e)

//security
#define DIA_C_U16_KDS_SYSTEM_SECURITY_LEVEL         DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0xF5)
#define DIA_C_U16_KDS_SYSTEM_SECURITY_LEVEL_INVET   DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0xFB)
#define DIA_C_U16_KDS_SYSTEM_SECURITY_KEY           DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER, 0xF6)
#define DIA_C_U16_KDS_AES_KEY_02                    DIA_M_KDS_ENTRY(KDS_TARGET_SECURITY, 0x17)
#define DIA_C_U16_KDS_AES_KEY_03                    DIA_M_KDS_ENTRY(KDS_TARGET_SECURITY, 0x18)

// Length information for the VW specific KDS identifiers presented above

// Identification
#if defined VARIANT_S_FTR_ENABLE_PROJECTBUILD_NISSAN_LCN2
#define DIA_C_U16_KDS_SYSINFO_LEN                   ((tU16) 32)
#define DIA_C_U16_KDS_OEM_TYPE_LEN                  ((tU16) 32)
#else
#define DIA_C_U16_KDS_SYSINFO_LEN                   ((tU16)  4)
#define DIA_C_U16_KDS_OEM_TYPE_LEN                  ((tU16)  4)
#endif
#define DIA_C_U16_KDS_CM_CONFIG_STRING_LEN          ((tU16) 64)

#define DIA_C_U16_KDS_ECU_SERIAL_NUM_LEN            ((tU16) 64)
#define DIA_C_U16_KDS_ECU_SUPPLIER_NUM_LEN          ((tU16)  4)
#define DIA_C_U16_KDS_ECU_MANUFACTURING_DATE_LEN    ((tU16)  3)
#define DIA_C_U16_KDS_ECU_PROD_TEST_SYSTEM_NUM_LEN  ((tU16)  4)

#define DIA_C_U16_KDS_ODX_FILE_ID_LEN               ((tU16) 25)
#define DIA_C_U16_KDS_ODX_FILE_VERSION_LEN          ((tU16)  6)
#define DIA_C_U16_KDS_SYSNAME_OR_ENGINETYPE_LEN     ((tU16) 13)

#define DIA_C_U16_KDS_VW_ECU_HW_NUM_LEN             ((tU16) 11)
#define DIA_C_U16_KDS_VW_ECU_HW_VERSION_NUM_LEN     ((tU16)  3)
#define DIA_C_U16_KDS_VW_ECU_SW_VERSION_NUM_LEN     ((tU16)  4)
#define DIA_C_U16_KDS_VW_SPARE_PART_NUM_LEN         ((tU16) 11)
#define DIA_C_U16_KDS_VW_SUPPLIER_NUM_LEN           ((tU16)  3)
#define DIA_C_U16_KDS_VW_SUPPLIER_PLANT_LEN         ((tU16)  3)
#define DIA_C_U16_KDS_VW_WORKSHOP_SYSTEM_NAME_LEN   ((tU16)  5)

// Coding
#define DIA_C_U16_KDS_CALIBRATION_DATE_LEN          ((tU16)  3)
#define DIA_C_U16_KDS_CALIBRATION_FINGERPRINT_LEN   ((tU16)  6)
#define DIA_C_U16_KDS_CODING_DATE_LEN               ((tU16)  3)
#define DIA_C_U16_KDS_CODING_FINGERPRINT_LEN        ((tU16)  6)
#define DIA_C_U16_KDS_CODING_VALUE_LEN              ((tU16) 12)
#define DIA_C_U16_KDS_CODING_VALUE_MIRROR_LEN       DIA_C_U16_KDS_CODING_VALUE_LEN

// Calibration
#define DIA_C_U16_KDS_EJECT_LOCK_MODE_LEN               ((tU16)  1)
#define DIA_C_U16_KDS_ENG_TEST_MODE_LEN                 ((tU16)  1)
#define DIA_C_U16_KDS_TEMP_ENG_TEST_MODE_LEN            ((tU16)  1)
#define DIA_C_U16_KDS_DEST_ENTRY_SPEED_LIMIT_LEN        ((tU16)  1)
#define DIA_C_U16_KDS_PHONE_BASE_VOLUME_LEVEL_LEN       ((tU16)  1)
#define DIA_C_U16_KDS_PHONE_CRADLE_TYPE_LEN             ((tU16)  1)
#define DIA_C_U16_KDS_PHONE_INTERNAL_DSP_MODE_LEN       ((tU16)  1)
#define DIA_C_U16_KDS_PHONE_VOICE_CTRL_MODE_LEN         ((tU16)  1)
#define DIA_C_U16_KDS_PHONE_INFO_CALL_NUM_LEN           ((tU16) 16)
#define DIA_C_U16_KDS_PHONE_BREAKDOWN_CALL_NUM_LEN      ((tU16) 16)
#define DIA_C_U16_KDS_COUNTRY_OF_SALE_ID_LEN            ((tU16)  2)
#define DIA_C_U16_KDS_MICROPHONE_SENSITIVITY_LEN        ((tU16)  1)
#define DIA_C_U16_KDS_REF_CHANNEL_DELAY_LEN             ((tU16)  1)
#define DIA_C_U16_KDS_DIMMING_DEFAULT_LEN               ((tU16)  1)
#define DIA_C_U16_KDS_HMI_LANGUAGE_LEN                  ((tU16)  1)
#define DIA_C_U16_KDS_TOUCH_PANAL_LEN					((tU16) 82)

// Evers 26.02.2011
// If we would use the same length for VW and Nissan this would require a complicated
// change in (generic) Read/Write ServiceHandler for Nissan configuration, as they
// assume that configuration item length == storage length.
#if defined VARIANT_S_FTR_ENABLE_PROJECTBUILD_NISSAN_LCN2
#define DIA_C_U16_KDS_BLUETOOTH_DEVICE_NAME_LEN         ((tU16) 24) // Nissan LCN2
#else
#define DIA_C_U16_KDS_BLUETOOTH_DEVICE_NAME_LEN         ((tU16) 30) // VW RNS315 China
#endif

#define DIA_C_U16_KDS_DISP_TEXT_OUTPUT_LIMITATION_LEN   ((tU16) 1)
#define DIA_C_U16_KDS_MICROPHONE_THRESHOLDS_LEN         ((tU16)  4)

#define DIA_C_U16_KDS_OPEL_END_MODEL_PART_NUMBER_LEN    ((tU16)  4)
#define DIA_C_U16_KDS_OPEL_SW_CONTENT_NUMBER_LEN            ((tU16) 12)
#define DIA_C_U16_KDS_OPEL_MTC_LEN                          ((tU16) 16)
#define DIA_C_U16_KDS_OPEL_PROD_DATE_AT_SUPPLIER_LEN        ((tU16)  4)
#define DIA_C_U16_KDS_OPEL_SYS_SUPPLIER_ID_LEN              ((tU16) 16)
#define DIA_C_U16_KDS_OPEL_DIA_DATA_ID_LEN                  ((tU16)  2)
#define DIA_C_U16_KDS_OPEL_DIA_DATA_ADDR_LEN                ((tU16)  1)

#define DIA_C_U16_KDS_NISSAN_SYSTEM_IDENTIFICATION_LEN  ((tU16) 24)
#define DIA_C_U16_KDS_NISSAN_BTNAME_LEN  				((tU16) 30) // Changed to match VW RNS315 China. Via UDS only 24 Byte supported
#define DIA_C_U16_KDS_NISSAN_SYSTEM_CONFIG_LEN			((tU16) 65)
#define DIA_C_U16_KDS_NISSAN_SYSTEM_CONFIG2_LEN			((tU16) 3)
#define DIA_C_U16_KDS_NISSAN_VEHICLE_INFO_LEN			((tU16) 10)
#define DIA_C_U16_KDS_NISSAN_HANDS_FREE1_LEN			((tU16) 11)
#define DIA_C_U16_KDS_NISSAN_HANDS_FREE2_LEN			((tU16) 234)
#define DIA_C_U16_KDS_NISSAN_TELEMATIC_PARAM_SET1_LEN	((tU16) 14)
#define DIA_C_U16_KDS_NISSAN_TELEMATIC_PARAM_SET2_LEN	((tU16) 238)
#define DIA_C_U16_KDS_NISSAN_FMAMTUNER_PARAM_SET_LEN	((tU16) 232)
#define DIA_C_U16_KDS_NISSAN_PARTS_NUMBER_LEN			((tU16) 27)
#define DIA_C_U16_KDS_NISSAN_AUDIO_PARAM_SET_LEN		((tU16) 200)
#define DIA_C_U16_KDS_NISSAN_ECOROUTE_LEN  				((tU16) 4)
#define DIA_C_U16_KDS_NISSAN_CAMERA_SYSTEM_LEN 			((tU16) 4)

//SECURITY

#define DIA_C_U16_KDS_SYSTEM_SECURITY_KEY_LEN       ((tU16) 10)
#define DIA_C_U16_KDS_SYSTEM_SECURITY_LEVEL_LEN     ((tU16)  1)
#define DIA_C_U16_KDS_SYSTEM_SECURITY_LEVEL_INVERT_LEN     ((tU16)  1)
#define DIA_C_U16_KDS_TYPE_AES_KEY_LEN              ((tU16) 16)

// for backward compatibility we include the old header file as well
#include "dia_KDSEntryLength.h"

// diagnosis 2nd fm antenna
#define  DIA_M_U8_DIAGNOSIS_2ND_FM_ANTENNA(cdata) \
    ((tU8)    (cdata[3] & 0x01))
#define  DIA_M_BOOL_DIAGNOSIS_2ND_FM_ANTENNA_IS_OFF(cdata) \
    ((tBool) ((cdata[3] & 0x01) == 0x00))
#define  DIA_M_BOOL_DIAGNOSIS_2ND_FM_ANTENNA_IS_ON(cdata) \
    ((tBool) ((cdata[3] & 0x01) == 0x01))

//------------------------------------------------------------------------------
//
// NISSAN specific KDS entries
//
//------------------------------------------------------------------------------
                                                                              /*0x0d*/                 /*0x00*/
#define DIA_C_U16_KDS_CODING_VALUE_NI               DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x00) // DIA_C_KDS_CUSTOMER_BASE_NI + 0)//0D 00
#define DIA_C_U16_KDS_CODING_VALUE_NI_LEN           ((tU16) 0x10)

//------------------------------------------------------------------------------
//
// Length of NISSAN specific KDS entries
//
//------------------------------------------------------------------------------

// defines for the columns in the configuration table
#define DIA_U16_CODING_VALUE_NI_EQ_POS                          ((tU16) 0x00)//car specific equilizing setting
#define DIA_U16_CODING_VALUE_NI_ILLUMINATION_POS                ((tU16) 0x01)
#define DIA_U16_CODING_VALUE_NI_ANTENNATYPE_POS                 ((tU16) 0x02)
#define DIA_U16_CODING_VALUE_NI_CAMERA_POS                      ((tU16) 0x03)//camera guidelines
#define DIA_U16_CODING_VALUE_NI_STEERINGWHEEL_POS               ((tU16) 0x04)//sws
#define DIA_U16_CODING_VALUE_NI_SECURITYCODE_POS                ((tU16) 0x05)
#define DIA_U16_CODING_VALUE_NI_CLOCK_POS                       ((tU16) 0x06)
#define DIA_U16_CODING_VALUE_NI_RADIO_POS                       ((tU16) 0x07)//countryspecific radio tuning
#define DIA_U16_CODING_VALUE_NI_PREMIUMAUDIO_POS                ((tU16) 0x08)
#define DIA_U16_CODING_VALUE_NI_SPEEDPULSE_POS                  ((tU16) 0x09)
#define DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS     ((tU16) 0x0A)
#define DIA_U16_CODING_VALUE_NI_SUB_OUT_POS                     ((tU16) 0x0B)
#define DIA_U16_CODING_VALUE_NI_XM_COUNTRY_POS                  ((tU16) 0x0C)

//XM Tuner (still used in FC_XMTuner
#define DIA_U8_CODING_VALUE_NI_XM_US                            ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_NI_XM_CANADA                        ((tU8) 0x01)

///////////////////////////////////////////////////////////////////////////////
//
// MC specific KDS entries
//
///////////////////////////////////////////////////////////////////////////////

#define DIA_C_KDS_CUSTOMER_BASE_MC                  ((tU8) 0x00)
#define DIA_C_U16_KDS_CODING_VALUE_MC               DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x00) //DIA_C_KDS_CUSTOMER_BASE_MC + 0) // 0x0D 0x00
#define DIA_C_U16_KDS_CODING_VALUE_MC_LEN           ((tU16) 0x10)

#define DIA_C_U16_KDS_CONFIGTABLE_ROW0              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x01) //DIA_C_KDS_CUSTOMER_BASE_MC + 1)//0D 01
#define DIA_C_U16_KDS_CONFIGTABLE_ROW1              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x02) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  1)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW2              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x03) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  2)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW3              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x04) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  3)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW4              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x05) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  4)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW5              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x06) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  5)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW6              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x07) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  6)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW7              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x08) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  7)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW8              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x09) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  8)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW9              DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x0A) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 +  9)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW10             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x0B) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 + 10)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW11             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x0C) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 + 11)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW12             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x01) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 + 12)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW13             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x01) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 + 13)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW14             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x01) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 + 14) //DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,DIA_C_KDS_CUSTOMER_BASE_MC + 15)
#define DIA_C_U16_KDS_CONFIGTABLE_ROW15             DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x01) //(DIA_C_U16_KDS_CONFIGTABLE_ROW0 + 15) //DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,DIA_C_KDS_CUSTOMER_BASE_MC + 16)

#define DIA_C_U16_KDS_CONFIG_TABLE_INDEX_MC         DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x11) //DIA_C_KDS_CUSTOMER_BASE_MC + 17)
#define DIA_C_U16_KDS_CONFIG_TABLE_INDEX_MC_LEN     ((tU16) 0x01)

#define DIA_C_U16_KDS_SPEED_LOCK_ENTRY              (DIA_C_U16_KDS_CONFIGTABLE_ROW0 + 229)

//
// system configuration for MC Opel
//

#define DIA_C_U16_KDS_CODING_VALUE_MC_OPEL          DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x25) // 0x0D 0x25
#define DIA_C_U16_KDS_CODING_VALUE_MC_OPEL_MIRROR   DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x26) // 0x0D 0x26
#define DIA_C_U16_KDS_CODING_VALUE_MC_OPEL_LEN      ((tU16) 0x10)

//
// BOSCH internal system configuration
//

#define DIA_C_U16_KDS_CODING_VALUE_BOSCH            DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0x12) //DIA_C_KDS_CUSTOMER_BASE_MC + 18) // 0x0D 0x12
#define DIA_C_U16_KDS_CODING_VALUE_BOSCH_LEN        ((tU16) 0x10)
#define DIA_C_U16_KDS_CODING_VALUE_BOSCH_MC_LEN     ((tU16) 0x10)

// software index
#define DIA_C_U16_KDS_SW_INDEX  DIA_M_KDS_ENTRY(DIA_C_KDS_TARGET_CUSTOMER,0xD9)  //0x0DD9
#define DIA_C_U16_KDS_SW_INDEX_LEN  (tU16)0x0C 

///////////////////////////////////////////////////////////////////////////////
//
// defines for MC specific configuration items
//
///////////////////////////////////////////////////////////////////////////////

// defines for the columns in the configuration table
#define DIA_U16_CODING_VALUE_MC_EQ_POS                          ((tU16) 0x00)//car specific equilizing setting
#define DIA_U16_CODING_VALUE_MC_ILLUMINATION_POS                ((tU16) 0x01)
#define DIA_U16_CODING_VALUE_MC_ANTENNATYPE_POS                 ((tU16) 0x02)
#define DIA_U16_CODING_VALUE_MC_CAMERA_POS                      ((tU16) 0x03)//camera guidelines
#define DIA_U16_CODING_VALUE_MC_STEERINGWHEEL_POS               ((tU16) 0x04)//sws
#define DIA_U16_CODING_VALUE_MC_SECURITYCODE_POS                ((tU16) 0x05)
#define DIA_U16_CODING_VALUE_MC_CLOCK_POS                       ((tU16) 0x06)
#define DIA_U16_CODING_VALUE_MC_RADIO_POS                       ((tU16) 0x07)//countryspecific radio tuning
#define DIA_U16_CODING_VALUE_MC_PREMIUMAUDIO_POS                ((tU16) 0x08)
#define DIA_U16_CODING_VALUE_MC_SPEEDPULSE_POS                  ((tU16) 0x09)
#define DIA_U16_CODING_VALUE_MC_BT_NOISEREDUCTION_CURVE_POS     ((tU16) 0x0A)
#define DIA_U16_CODING_VALUE_MC_SUB_OUT_POS                     ((tU16) 0x0B)
#define DIA_U16_CODING_VALUE_MC_XM_COUNTRY_POS                  ((tU16) 0x0C)
#define DIA_U16_CODING_VALUE_MC_SECONDANTENNATYPE_POS           ((tU16) 0x0D)
#define DIA_U16_CODING_VALUE_MC_IGNITION_POS                    ((tU16) 0x0E)

// EQBodyStyle: car specific equializer settings
#define DIA_U8_CODING_VALUE_MC_EQ_NA                            ((tU8) 0X00)
#define DIA_U8_CODING_VALUE_MC_EQ_FLAT                          ((tU8) 0X00)

//illumination
#define DIA_U8_CODING_VALUE_MC_ILLUMINATION_REDORANGE           ((tU8) 0x01)
#define DIA_U8_CODING_VALUE_MC_ILLUMINATION_YELLOWORANGE        ((tU8) 0x02)

//antenna type
#define DIA_U8_CODING_VALUE_MC_ANTENNATYPE_PASSIVE              ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_ANTENNATYPE_ACTIVE               ((tU8) 0x01)//active antenna with passive tuning
#define DIA_U8_CODING_VALUE_MC_ANTENNATYPE_ACTIVE_AGC           ((tU8) 0x02)
#define DIA_U8_CODING_VALUE_MC_ANTENNATYPE_800MM_ROD            ((tU8) 0x03)

//camera guidelines
#define DIA_U8_CODING_VALUE_MC_CAMERA_GUIDELINES_NOT_AVAILABLE  ((tU8) 0x00)

//steering wheel
#define DIA_U8_CODING_VALUE_MC_SWS_NA                           ((tU8) 0x00)

//security
#define DIA_U8_CODING_VALUE_MC_SECURITY_CODE                    ((tU8) 0x01)
#define DIA_U8_CODING_VALUE_MC_CODE                             ((tU8) 0x01) // deprecated

//clock
#define DIA_U8_CODING_VALUE_MC_CLOCK_OFF                        ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_CLOCK_ON                         ((tU8) 0x01)

//radio tuning
#define DIA_U8_CODING_VALUE_MC_RADIOTUNING_EUR                  ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_RADIOTUNING_NAR                  ((tU8) 0x01)
#define DIA_U8_CODING_VALUE_MC_RADIOTUNING_JPN                  ((tU8) 0x02)
#define DIA_U8_CODING_VALUE_MC_RADIOTUNING_RUSSIA               ((tU8) 0x03)

//premium audio
#define DIA_U8_CODING_VALUE_MC_PREMIUMAUDIO_NOT_PRESENT        	((tU8) 0x00) // deprecated
#define DIA_U8_CODING_VALUE_MC_PREMIUMAUDIO_NONE            	((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_PREMIUMAUDIO_BOSE            	((tU8) 0x01)
#define DIA_U8_CODING_VALUE_MC_PREMIUMAUDIO_ROCK            	((tU8) 0x02)

//speed pulse
#define DIA_U8_CODING_VALUE_MC_SPEEDPULSE_8PR                   ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_SPEEDPULSE_2PR                   ((tU8) 0x01)

//bluetooth noise reduction curve
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_NOCHANGE             ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_NOT_DEFINED          ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_1		            ((tU8) 0x01)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_2		            ((tU8) 0x02)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_3		            ((tU8) 0x03)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_4		            ((tU8) 0x04)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_5		            ((tU8) 0x05)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_6		            ((tU8) 0x06)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_7		            ((tU8) 0x07)
#define DIA_U8_CODING_VALUE_MC_BT_NR_CURVE_8		            ((tU8) 0x08)

//Sub-Out
#define DIA_U8_CODING_VALUE_MC_SUB_OUT_OFF                      ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_SUB_OUT_ON                       ((tU8) 0x01)

//XM Tuner
#define DIA_U8_CODING_VALUE_MC_XM_US                            ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_XM_CANADA                        ((tU8) 0x01)

// ignition
#define DIA_U8_CODING_VALUE_MC_IGNITION_CAN                     ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_MC_IGNITION_HARDWIRED               ((tU8) 0x01)

///////////////////////////////////////////////////////////////////////////////
//
// defines for BOSCH specific configuration items
//
///////////////////////////////////////////////////////////////////////////////

// defines for the columns in the configuration table
#define DIA_U16_CODING_VALUE_BOSCH_DIMMING_POS                  ((tU16) 0x00) // dimming setting
#define DIA_U16_CODING_VALUE_BOSCH_IGNITION_POS                 ((tU16) 0x01)
#define DIA_U16_CODING_VALUE_BOSCH_STARTUP_ANIMATION_POS        ((tU16) 0x02)

// dimming settings
#define DIA_U8_CODING_VALUE_BOSCH_DIMMING_NOT_AVAILABLE         ((tU8)  0x00)
#define DIA_U8_CODING_VALUE_BOSCH_DIMMING_CAN                   ((tU8)  0x01)
#define DIA_U8_CODING_VALUE_BOSCH_DIMMING_PWM                   ((tU8)  0x02)

// ignition settings
#define DIA_U8_CODING_VALUE_BOSCH_IGNITION_CAN                  ((tU8)  0x00)
#define DIA_U8_CODING_VALUE_BOSCH_IGNITION_HARDWIRED            ((tU8)  0x01)

// startup animation settings
#define DIA_U8_CODING_VALUE_BOSCH_STARTUP_ANIMATION_DEFAULT     ((tU8)  0x00)
#define DIA_U8_CODING_VALUE_BOSCH_STARTUP_ANIMATION_OFF         ((tU8)  0xFF)

///////////////////////////////////////////////////////////////////////////////
//
// macros for checking the bluetooth noise reduction
//
///////////////////////////////////////////////////////////////////////////////

#define  DIA_M_U8_BT_NR_CURVE(cdata) \
    ((tU8) (cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]))

#define  DIA_M_BOOL_BT_NR_CURVE_IS_NOCHANGE(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_NOCHANGE))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_NOT_DEFINED(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_NOT_DEFINED))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_PSR1(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_1))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_PSR2(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_2))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_PSR3(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_3))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_PSR4(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_4))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_PSR5(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_5))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_PSR6(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_6))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_PSR7(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_7))
#define  DIA_M_BOOL_BT_NR_CURVE_IS_PSR8(cdata) \
    ((tBool) ((cdata[DIA_U16_CODING_VALUE_NI_BT_NOISEREDUCTION_CURVE_POS]) == DIA_U8_CODING_VALUE_NI_BT_NR_CURVE_8))

//Sub-Out (imported from older NISSAN project to retain compatibility for the RU library 
#define DIA_U8_CODING_VALUE_NI_SUB_OUT_OFF                      ((tU8) 0x00)
#define DIA_U8_CODING_VALUE_NI_SUB_OUT_ON                       ((tU8) 0x01)

#endif /*DIA_KDSENTRIES_H_*/
