/************************************************************************
* FILE:         dia_tclService.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: diagnostics
*----------------------------------------------------------------------
*
* DESCRIPTION: CCA Server component for the ETAS test tool
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 17.10.04  | CM-DI/ESA2 Wersuhn | initial version
* 06.06.05  | 3SOFT  Drenkhahn   | converted for ETAS
*
*************************************************************************/

#ifndef __INCLUDED_DIA_SERVICE__
#define __INCLUDED_DIA_SERVICE__

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TOUCHPANEL__
#include "common/interfaces/dia_ITouchPanel.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYTEST__
#include "common/interfaces/dia_IDisplayTest.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_NAVIGATION__
#include "common/interfaces/dia_INavigation.h"
#endif

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__
#include "common/framework/application/dia_RemoteControlPlugin.h"
#endif

#define DIAGNOSTICS_S_IMPORT_INTERFACE_GENERIC
#define DIAGNOSTICS_S_IMPORT_INTERFACE_MSG
#include "fc_diagnosis_if.h"

#ifndef __INCLUDED_DIA_INTERFACE_HMILANGUAGE__
#include "common/interfaces/dia_IHMILanguage.h"
#endif

#ifndef __INCLUDED_DIA_NATIVE_KDS_LISTENER_INTERFACE__
#include "common/framework/config/dia_IKDSListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERNALTESTERCLIENT__
#include <common/framework/engine/dia_InternalTesterClient.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INTERNALTESTER__
#include <common/interfaces/dia_IInternalTester.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS_LISTENER__
#include <common/interfaces/dia_ISystemSettingsListener.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_CONFIGITEM_LISTENER__
#include "common/interfaces/dia_IConfigItemListener.h"
#endif


//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------

struct tNotification
{
   tU16  u16AppID;
   tU16  u16CmdCounter;
   tU16   u16RegisterID;
   tU16  u16FunctionID;
   tU16  u16SubID;
};

struct TNotificationKds
{
   tU16 u16AppID;
   tU16 u16CmdCounter;
   tU16 u16RegisterID;
   tU32 u32CcaSubId;
};

struct TNotificationConfigItem
{
	tU16 u16AppID;
	tU16 u16CmdCounter;
	tU16 u16RegisterID;
	tU32 u32CcaSubId;
};

//typedef std::map<tU32,TNotificationKds> TMapKdsNotTable;

//typedef std::list< tU16 > TKdsChangeList;
//

class fi_tclTypeBase;
//class dia_tclDefset_SetToDefault;
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_tclService
   : public ahl_tclBaseWork,
     public dia_RemoteControlPlugin,
     public dia_ISystemSettingsListener,
     public dia_ITouchPanel,
     public dia_IDisplayTest,
     public dia_INavigation,
     public dia_IHMILanguage,
     public dia_IKDSListener,
     public dia_InternalTesterClient,
     public dia_IConfigItemListenerImpl
{
   enum tenUserSysSetState
   {
       EN_USERSYSSET_IDLE,
       EN_USERSYSSET_RUNNING
   } menSysSetState;

public:
   dia_tclService(diagnostics_tclApp* poMain);
   virtual ~dia_tclService();

   tVoid vDiagnoticTestCallback(bool) const;
   tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState) const;
   tBool bSendDefaultSettingsResult(tBool bResult);
   tBool bSendClearDestinationMemoryStatus(tBool) const;
   tVoid vSendClearDiaglogResult(amt_tclServiceData* poMessage) const;
   tBool bSendGetDestinationMemorySizeStatus(tBool) const;
   tBool bSendGetLocaleStatus(tBool) const;
   tVoid vSendStartDiagnosticTestResult(bool) const;
   tVoid vSendStopDiagnosticTestResult(bool) const;
   tVoid vSendReadDiaglogResult(amt_tclServiceData* poMessage) const;
   tBool bSendResetSecurityStatus(tBool) const;
   tBool bSendSetDisplayStatus(tU8, tCString, tCString, tCString, tCString, tCString, tCString) const;
   tBool bSendSetFactorySettingsStatus(tU8, tU8, tBool, tU16) const;
   tBool bSendSetLocaleResultStatus(tBool) const;
   tBool bSendSetLocaleStartStatus(tU8, tU8, tU8, tU8) const;
   tVoid vSendSetRVCSignal(tBool) const {}
   tBool bSendSimulateKeyPressStatus(tU8, tS8) const;
   tVoid vSendSetSpeedLockStatus(const ahl_tNotification*,const tBool);
   tVoid vSendGetSpeedLockStatus(const ahl_tNotification*,const midw_fi_tcl_e16_SpeedLock&,const tU8);

   //! this method is called to trigger a coding update
   tBool bCodingValueUpdate ( tVoid ) const;
   //! this method is called to evaluate the result of a coding update
   tBool bEvaluateCodingUpdateResult ( amt_tclServiceData* poMessage ) const;

   virtual tVoid vSystemSetFailedParameterIds(std::vector<tU16>& vectorDiff);
//   virtual tVoid vSystemSetResult(dia_tenSysSetAction enAction, tDiaResult enResult);
//   virtual tVoid vSystemSetResult(dia_tenSysSetAction enAction, dia_tenSysSetResult enResult);
   virtual void onSystemSettingProcessed ( dia_UID typeID, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, tCookieType cookie );
   virtual void onSystemSettingProcessed ( dia_UID typeID, const dia_SystemSettingExtendedData& extData, const std::vector<dia_UID>& modules, tDiaResult resultCode, tCookieType cookie );

   //
   // Methods from interface dia_ITouchPanel
   //

   //! start manual calibration procedure for touch panel alignment
   virtual tDiaResult startTouchPanelAlignment ( tVoid  );

   // Methods from interface dia_IDisplayTest
   virtual tDiaResult setDisplayPatternID ( dia_eDisplayPatternID ePatternID );

   //
   // Methods from interface dia_INavigation
   //

   //! start route calculation procedure
   virtual tDiaResult startRouteCalculation ( tS32, tS32, tS32, tS32, tU8, tU8, tU8 );
   //! request route calculation result status
   virtual tDiaResult requestRouteCalcResultStatus ( tVoid );

   //
   // Methods from interface dia_IHMILanguage
   //

   //! set new hmi language
   virtual tDiaResult setHMILanguage ( dia_eCMLanguage u8Country );
   //! read current hmi language
   virtual tDiaResult getHMILanguage ( tVoid  );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_RemoteControlPlugin methods
   //
   //-------------------------------------------------------------------------

   //! set remote control to the specified mode
   virtual tDiaResult requestRemoteControlMode ( dia_eRemoteCtrlMode mode, dia_RemoteControlSettings settings = DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT);


   //! direct read access to KDS
   virtual tVoid vOnKDSUpdate ( tU16 kdsKey, tU8 kdsData[], tU16 length );

   //! start the specified routine
   virtual void onInternalTesterResponse ( std::vector<tU8>& response, tCookieType cookie );

   //! response to other ConfigItems
   virtual void vOnConfigItemUpdate ( tU32 ConfigItem );
   //! response to an asynchronous read
   virtual void vOnConfigItemGetComplete( tU32 ConfigItem, tDiaResult retCode, std::vector<tU8>& data, void* cookie);
   //! response to an asynchronous write
   virtual void vOnConfigItemSetComplete( tU32 ConfigItem, tDiaResult retCode, void* cookie);


protected:
   //! deprecated default constructor without implementation
   dia_tclService ( tVoid );

   //! handle incoming native diagnosis request
   void vHandleNativeDiagnosisRequest ( amt_tclServiceData* poMessage );

   tVoid vHandleTouchPanelCalibrationResult ( amt_tclServiceData* poMessage ) const;

   tVoid vHandleStartRouteCalculation (amt_tclServiceData* poMessage);
   tVoid vHandleRouteCalculationResult(amt_tclServiceData* poMessage);
   tVoid vHandleKdsEntryProperty ( amt_tclServiceData* poMessage );
   tVoid vSendKdsStatusEntry ( amt_tclServiceData* poMessage );
   tVoid vSendKdsStatusEntry ( const ahl_tNotification* pNot, tU32 u32KdsEntry );
   tVoid vSendKdsStatusEntry ( const ahl_tNotification* pNot, tU32 u32KdsEntry, const tU8 kdsData[], tU16 length );



   tVoid vCarConfig(amt_tclServiceData* poMessage);
   tVoid vRVCSignalStatus(amt_tclServiceData* ) const {}
   tVoid vSendLanguage( const amt_tclServiceData* )const;
   tVoid vSendSpeedLock(const amt_tclServiceData* ) const {}
   tVoid vClearDestinationMemory(amt_tclServiceData* poMessage) const;
   tVoid vClearDiaglog(amt_tclServiceData* poMessage) const;
   tVoid vEnableTimeSlot(amt_tclServiceData* poMessage) const;
   tVoid vGetDestinationMemorySize(amt_tclServiceData* poMessage) const;
   tVoid vGetLocale(amt_tclServiceData* poMessage);
   tVoid vPerformDiagnosticTest(midw_fi_tcl_e8_TestRoutines const&) const {}
   tVoid vPerformOnDemandSelfTest() const {}
   tVoid vReadDiaglog(amt_tclServiceData* poMessage) const;
   tVoid vResetSecurity(amt_tclServiceData* poMessage);
   tVoid vSendClearDestinationMemoryStatus(amt_tclServiceData const* poMessage) const;
   tVoid vSendGetDestinationMemorySizeStatus(amt_tclServiceData const* poMessage) const;
   tVoid vSendMsg(amt_tclServiceData const*, fi_tclTypeBase const&, tU8) const;
   tVoid vSendResultMsg(amt_tclServiceData const*, fi_tclTypeBase const&) const;
   tVoid vSendRVCSignalStatusRequest(amt_tclServiceData const* poMessage) const;
   tVoid vSendSetFactorySettings(amt_tclServiceData const* poMessage);
   tVoid vSendSetRVCSignal(amt_tclServiceData const* poMessage) const;
   tVoid vSendSimulateKeyPressStatus(amt_tclServiceData const* poMessage) const;
   tVoid vSendStatusMsg(amt_tclServiceData const*, fi_tclTypeBase const&) const;
   tVoid vSetDefaultSettings(amt_tclServiceData* poMessage);
   tVoid vSetDisplay(amt_tclServiceData* poMessage);
   tVoid vSetFactorySettingsStatus(amt_tclServiceData* poMessage);
   tVoid vSetLocaleResult(amt_tclServiceData* poMessage);
   tVoid vSetLocaleStart(amt_tclServiceData* poMessage);
   tVoid vSetRVCSignal(amt_tclServiceData* poMessage) const;
   tVoid vSimulateKeyPress(amt_tclServiceData* poMessage) const;
   tVoid vStartDiagnosticTest(amt_tclServiceData* poMessage) const;
   tVoid vStopDiagnosticTest(amt_tclServiceData* poMessage) const;
   tVoid vUpdateAllClients(fi_tclTypeBase const&, tU16) const;

   tVoid vHandleDiagConfigItem ( amt_tclServiceData* poMessage );
   tVoid vSendDiagConfigItemEntry ( const ahl_tNotification* pNot, tU32 u32ConfigItem );

   bool  bUpreg(amt_tclServiceData const* poMessage);
   bool  bRelUpreg(amt_tclServiceData const* poMessage);

   tVoid vHandleRemoteControlMessage ( amt_tclServiceData* poMessage );

   tVoid vSendError ( tU16 u16TargetID, tU16 u16RegisterID, tU16 u16CmdCounter, tU16 u16Fid );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_tclService)

protected:
   std::map<tU32,TNotificationKds> tMapKdsEntryNotify;

   std::map<tU32,TNotificationConfigItem> tMapConfigItemEntryNotify;

private:
   // pointer to application object used to post CCA messages
   diagnostics_tclApp* m_poGWMain;

   tU16  m_u16ClientAppID;
   tU16  m_u16ClientSubAppID;
   tU16  m_u16RegisterID;
   tU8   m_u8ProtocolId;
   tU16  m_u16CmdCounter;
   tU16  m_u16SubID;
   midw_fi_tcl_e8_TestRoutines   m_eCurrentTest;
   tNotification                 m_oDefSetMessage;
   tBool m_bEnableProperty;
   tBool m_bRunSysSet;
};

#endif // __INCLUDED_DIA_SERVICE__
