/************************************************************************
* FILE:         dia_tclDiagSessionUds.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Class for the diagnostic session of the UDS protocol
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 16.02.05  | 3SOFT Drenkhahn    | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_DIAGSESSION_UDS__
#define __INCLUDED_DIA_DIAGSESSION_UDS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION__
#include "common/depricated/dia_tclDiagSession.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_RUNLEVEL_LISTENER__
#include <common/interfaces/dia_IRunLevelListener.h>
#endif

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef __INCLUDED_DIA_QUEUE__
#include "common/framework/application/dia_Queue.h"
#endif

// msg buffer class
class dia_MessageBufferUDS;
class dia_MessageBuffer;
// body class
class dia_tclDiagSessionBodyUds;

extern dia_tclDiagSessionUds* getInstanceOfDiagSessionUDS ( void );
extern void releaseInstanceOfDiagSessionUDS ( void );


class dia_tclDiagSessionUds
    : public dia_tclDiagSession,
      public dia_ActiveObject,
      public dia_IRunLevelListener
{
   friend class dia_tclDiagSessionBodyUds;
   friend class dia_Application;

   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_tclDiagSessionUds);

public:
    // Prototype for the service handler
    virtual void vLookupSrvcHandler();
    // msg buffer accessors
    virtual dia_MessageBufferUDS& oDiagMsgBuffer() const;

    dia_MessageBufferUDS *poUdsMsgBuffer(); // const;

    // null response (fabricates a confirmation without sending the response to the tester)
    static void vNullResponse(const tU8*, tU16, tCookieType);

    virtual void vEmit( tclEvent* pEvent ) const;

protected:
    // Constructor
    dia_tclDiagSessionUds ( void );
    // Destructor
    virtual ~dia_tclDiagSessionUds ( void );

#ifdef __DIA_UNIT_TESTING__
public:
#endif
    //! setup method for the application
    virtual tDiaResult setup ( void );

    //! shutdown method for the application
    virtual tDiaResult tearDown ( void );

#ifdef __DIA_UNIT_TESTING__
protected:
#endif
    //! overloaded method from dia_IRunLevelListener
    virtual tVoid vOnRunLevelChanged ( dia_enRunlevel newLevel, dia_enRunlevel oldLevel );

protected:
//    // worker thread for diag sessions
//    static void vDiagSessionThread(void*);
    //! object specific thread function
    virtual void vThreadEntrypointObject ( void );

    //! pointer to the FSM object
    dia_tclDiagSessionBodyUds* mpBody;

   //! queue used by the objects thread to store incoming messages
    dia_Queue<tclEvent>* mpMsgQueue;

    // name of msg queue of worker thread
    static tCString strQueueName;
    static tCString strThreadName;

};


#endif
