/************************************************************************
* FILE:         dia_tclDiagSession.cpp
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Virtual base class for the diagnostic session
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 16.09.05  | 3SOFT Drenkhahn    | initial version
* 12.01.05  | John W P Elkins    | removal of text output in vDeleteSrvcHandler
*                                  + reformat of file for readability
*************************************************************************/

//
//  Include files
//

#ifndef __INCLUDED_DIA_DIAGSESSION__
#include "common/depricated/dia_tclDiagSession.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE__
#include "common/framework/engine/dia_Engine.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION__
#include "common/framework/engine/dia_EngineConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include <common/framework/engine/dia_ServiceDispatcher.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "framework/dia_main.h"
#endif

dia_UID dia_tclDiagSession::tclEvent::serial = 0;

//-----------------------------------------------------------------------------

dia_tclDiagSession::dia_tclDiagSession ( void )
   : poDiagMsgBuffer(OSAL_NULL),
////     hMsgQueue(OSAL_C_INVALID_HANDLE),
//     hThreadId(OSAL_ERROR),
     mEngineID(DIA_UID_ENGINE_UNKNOWN)
{
   if ( oTimer.s32Create() == OSAL_OK )
   {
       oTimer.addTimerListener(this);
   }
   else
   {
       DIA_TR_ERR("ERR: UNABLE TO SETUP TIMER !!");
   }
}

//-----------------------------------------------------------------------------

dia_tclDiagSession::~dia_tclDiagSession()
{
    // destructors should not throw exceptions (--> lint), but functions called in the
   // could possibly throw excepections. So we catch them here and raise an assert
   _BP_TRY_BEGIN
   {
       poDiagMsgBuffer = OSAL_NULL;

       tS32 s32Result = oTimer.s32Delete();
       DIA_ASSERT(s32Result == OSAL_OK);

       oTimer.removeTimerListener(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_tclDiagSession::~dia_tclDiagSession !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_tclDiagSession::setDiagnosisMessageBuffer(/*const*/ tclEventReqRx& oEv)
{
   dia_tclFnctTrace trc("dia_tclDiagSession::setDiagnosisMessageBuffer");

   tDiaResult retCode = DIA_FAILED;

   if( OSAL_NULL != poDiagMsgBuffer )
   {
      DIA_TR_ERR("##### ERROR in setDiagnosisMessageBuffer() - UNABLE TO SET BUFFER, BECAUSE BUFFER IS IN USE !! #####");
      return DIA_FAILED;
   }

   poDiagMsgBuffer = oEv.poMsgBuffer();

   if ( poDiagMsgBuffer == OSAL_NULL )
   {
      DIA_TR_ERR("##### ERROR in setDiagnosisMessageBuffer() - FAILED. INVALID MESSAGE BUFFER !! #####");
      return DIA_E_INVALID_POINTER;
   }

   mEngineID = DIA_UID_ENGINE_UNKNOWN;
   dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
   if ( !pEngineMgr )
   {
      DIA_TR_ERR("##### ERROR in setDiagnosisMessageBuffer() - FAILED. NO ENGINE MANAGER !! #####");
      return DIA_E_INVALID_POINTER;
   }

   const std::map<dia_UID,dia_Engine*>& engines = pEngineMgr->getEngines();
   std::map<dia_UID,dia_Engine*>::const_iterator cIter = engines.begin();
   for ( ; cIter != engines.end(); cIter++ )
   {
      if ( !(cIter->second) ) continue;
      if ( !(cIter->second->isServer()) ) continue;
      const dia_EngineServer* pEngine = static_cast<dia_EngineServer*>(cIter->second);
      if ( pEngine && pEngine->getServerConfiguration().validateProtocol(*poDiagMsgBuffer) == DIA_SUCCESS )
      {
         mEngineID = dia_getHashCodeFromString(cIter->second->getName());
         break;
      }
   }

   if ( mEngineID != DIA_UID_ENGINE_UNKNOWN )
   {
      DIA_TR_INF("dia_tclDiagSession::setDiagnosisMessageBuffer returned DIA_SUCCESS");
      retCode = DIA_SUCCESS;
   }

   return retCode;
}


//-----------------------------------------------------------------------------

void dia_tclDiagSession::deleteDiagnosisMessageBuffer ( void )
{
   dia_tclFnctTrace trc("dia_tclDiagSession::deleteDiagnosisMessageBuffer");

   if (poDiagMsgBuffer != OSAL_NULL)
   {
      DIA_TR_INF("delete poDiagMsgBuffer");
      OSAL_DELETE poDiagMsgBuffer;
      poDiagMsgBuffer = OSAL_NULL;
   }
   else
   {
      DIA_TR_INF("no poDiagMsgBuffer to delete");
   }
}

//-----------------------------------------------------------------------------

void
dia_tclDiagSession::vOnTimerElapsed ( dia_TimerID /*id*/ )
{
   vEmit(OSAL_NEW tclEventTimeout());
}

//-----------------------------------------------------------------------------

tBool
dia_tclDiagSession::bIsServiceActive ( void )
{
   dia_tclFnctTrace trc("dia_tclDiagSession::bIsServiceActive");

   tBool retCode = FALSE;

   dia_EngineManager* pEngineMgr = getInstanceOfEngineManager();
   if ( pEngineMgr )
   {
      dia_EngineServer* pEngine = 0;
      if ( pEngineMgr->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS )
      {
         retCode = pEngine->getDispatcher()->bIsServiceActive();
      }
   }

   DIA_TR_INF("bIsServiceActive returned retCode=0x%08X", retCode);

   return retCode;
}
