/************************************************************************
* FILE:         dia_main.h
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Main application class for the diagnostics component
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                | Modification
* 17.10.04  | CM-DI/ESA2 Wersuhn    | initial version
* 16.09.05  | 3SOFT Drenkhahn       | first adjustments
* 23.08.07   | Srikumar.S            | Updated for Vehicle Data Client handler.
* 09.04.08  | Prakash G.D(RBEI\ECM6)| Adapted for CCA Port Handling
*************************************************************************/

#ifndef __INCLUDED_DIA_MAIN__
#define __INCLUDED_DIA_MAIN__

// 64 bit porting
#ifndef _GLIBCXX_USE_CXX11_ABI
#define _GLIBCXX_USE_CXX11_ABI 1
#endif

//lint -e1736 Info:    redundant access specifier (public|protected|private)

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

//lint -e553 gib2hi: ok to assume 0 for preprocessor variable, because it is only available on windows based systems
#if _MSC_VER >= 1200
#pragma warning(push, 3)
#pragma warning(disable: 4355)
#pragma warning(disable: 4250)
#endif
//lint +e553 gib2hi

#ifndef __DIA_UNIT_TESTING__

#ifndef __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_OSAL_INTERFACE__
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_MEMORY
#include "osal_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif

#ifndef __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif

// traces
#define ET_TRACE_INFO_ON
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#ifndef __INCLUDED_DIA_TRACE__
#include "common/framework/trace/dia_trace.h"
#endif

// error types and codes
#ifndef __INCLUDED_DIA_ERROR__
#include "common/framework/errmgmt/dia_error.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_APPLICATION_STATE_CONTROL_LISTENER__
#include <common/interfaces/dia_IApplicationStateControlListener.h>
#endif

#endif


#define DIA_USED_APP_ID    CCA_C_U16_APP_DIAGDEBUG
#define DIA_USED_SRV_ID    CCA_C_U16_SRV_DIAGDEBUG

#define DIA_C_U32_UDS_FOLLOW_UP_TIME     10000

#define DIA_C_U8_STATE_INVALID     (tU8)0x00
#define DIA_C_U8_LEAVE_STATE       (tU8)0x01
#define DIA_C_U8_STATE_LEFT        (tU8)0x02
#define DIA_C_U8_ENTER_STATE       (tU8)0x03
#define DIA_C_U8_STATE_ENTERED     (tU8)0x04

class dia_Application;
class dia_Factory;

class dia_tclDiagSession;
class dia_tclDiagSessionUds;
class dia_tclService;
class ahl_tclClientPortMngr;

// CCA constants for array sizes and semaphore name
#define DIAGNOSTICS_FUNCARRAY_SIZE    30 //properties with Upreg
#define DIAGNOSTICS_NOTTABLE_SEM_NAME      "DIAGNOSTICS_NOTTABLESEM"

// Events
#define DIA_EVENT_NAME   "DiaEventHdl"
#define DIA_EVENT_DEFSET_TIMEOUT            0x00000001
#define DIA_EVENT_EXTCOMMS                  0x00000002
#define DIA_EVENT_STARTUP_DONE              0x00000004
#define DIA_EVENT_SYSSET_FSM_EVENTS         0x00000080
#define DIA_EVENT_DELETE_THREAD             0x00000100
#define DIA_EVENT_TESTER_PRESENT            0x00000200 // Ford MFD - Tester present => restart follow-up time timer
#define DIA_EVENT_START_DEFAULT_SESSION     0x00000400 // Ford MFD - Start of default session => restart follow-up time timer
#define DIA_EVENT_SENT_UDS_RESPONSE         0x00000800 // Ford MFD - Sent UDS response in default session => restart follow-up time timer
#define DIA_EVENT_FOLLOW_UP_TIME_TIMEOUT    0x00001000 // Ford MFD - UDS follow-up time timeout => clear substate DIAG_REQ
#define DIA_EVENT_REC_UDS_REQUEST           0x00002000 // Ford MFD - UDS request received
#define DIA_EVENT_DEFSET_DONE               0x00004000 // VW - Defset is finished
#define DIA_EVENT_EOL_UPDATE_FINISH         0x00008000 // GM - EOLUpdateTrigger finish
#define DIA_EVENT_SHUTDOWN_THREAD           0x00010000
#define DIA_EVENT_START_RUNIN               0x00020000
#define DIA_EVENT_LOG_DATA                  0x00040000 // data logger update event
#define DIA_EVENT_START_PDX_FLASHING        0x00080000
#define DIA_EVENT_FIELD_LOAD_DATA           0x00100000

#define DIA_EVENT_MASK  (\
        DIA_EVENT_DEFSET_TIMEOUT | \
        DIA_EVENT_EXTCOMMS | \
        DIA_EVENT_STARTUP_DONE | \
        DIA_EVENT_SYSSET_FSM_EVENTS | \
        DIA_EVENT_DELETE_THREAD | \
        DIA_EVENT_TESTER_PRESENT | \
        DIA_EVENT_START_DEFAULT_SESSION | \
        DIA_EVENT_SENT_UDS_RESPONSE | \
        DIA_EVENT_FOLLOW_UP_TIME_TIMEOUT | \
        DIA_EVENT_REC_UDS_REQUEST | \
        DIA_EVENT_DEFSET_DONE | \
        DIA_EVENT_EOL_UPDATE_FINISH | \
        DIA_EVENT_START_RUNIN | \
        DIA_EVENT_LOG_DATA | \
        DIA_EVENT_START_PDX_FLASHING | \
        DIA_EVENT_FIELD_LOAD_DATA \
        )

typedef void (*CBFunc_SPMDiagSubstate) ( tBool mode );

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class diagnostics_tclApp
#ifndef __DIA_UNIT_TESTING__
   : public ail_tclOneThreadAppInterface,
     public dia::IApplicationStateControlListener
#endif
{
public:
    //! singleton constructor used by the system to startup the diagnosis application
    static diagnostics_tclApp* getInstance ( void );
    static void deleteInstance(void);

   ////////////////////////////////////////////////////////////////////////////
    // public methods

    /// @brief Initialization of diag application
    /// @return function success or failure
    /// @retval TRUE  success
    /// @retval FALSE failure
    virtual tBool bOnInit();

    virtual void  vOnAsyncRegisterConf( tU16 u16RegisterId,
        tU16 u16ServerAppId,
        tU16 u16ServiceId,
        tU16 u16SourceSubID );

    virtual void  vOnAsyncRegisterConfirmation( tU16 u16RegisterId,
        tU16 u16ServerAppId,
        tU16 u16ServiceId,
        tU16 u16SourceSubID );

    /// @brief Shutdown of diag application
    virtual void vOnApplicationClose();

    //! Framework function overwritten to remove the clients from notification table
   virtual void vOnUnregister(tU16 u16ServiceID,tU16 u16RegisterID);

    /// @brief Handle diag application state change
    /// @param u32OldAppState old application state
    /// @param u32AppState new application state
    virtual void vOnNewAppState ( tU32 srcAppState, tU32 destAppState);

    //! application state change for the given application states is pending
    virtual void onApplicationStateChangePending ( dia::ApplicationStateID srcStateID, dia::ApplicationStateID destinationStateID );
    //! application state change for the given application states is done
    virtual void onApplicationStateChanged ( dia::ApplicationStateID stateID );

    #ifndef __DIA_UNIT_TESTING__
    /// @brief Handle incoming ServiceData messages
    /// @param poMessage received message
    /// Non-CCA msgs may also be given to vOnNewMessage(), TODO: check
    virtual void vOnNewMessage ( amt_tclBaseMessage* poMessage );

    void vOnDispatchMessage(amt_tclBaseMessage* poMessage);

    virtual ail_tenCommunicationError enPostMessage (amt_tclServiceData* poMessage, tBool bDeleteMsgOnNoSuccess = FALSE, tU32 u32Prio = OSAL_C_U32_MQUEUE_PRIORITY_LOWEST);  //lint !e1735: checked that default param is equal to base class default param
#endif

protected:
    diagnostics_tclApp();          // constructor
    virtual ~diagnostics_tclApp(); // destructor

    ////////////////////////////////////////////////////////////////////////////
    // diag app as server

    /// @brief Return version of provided service
    /// @param u16ServiceID service identification number
    /// @param rfu16MajorVersion major version number
    /// @param rfu16MinorVersion minor version number
    /// @param rfu16PatchVersion patch version number
    /// @return providability of service @a u16ServiceID
    /// @retval TRUE
    /// @retval FALSE
    virtual tBool bGetServiceVersion(tU16 u16ServiceID,
        tU16& rfu16MajorVersion,
        tU16& rfu16MinorVersion,
        tU16& rfu16PatchVersion);

public:
    ////////////////////////////////////////////////////////////////////////////
    // diag app as client

    /// @brief React on changes in service availability
    /// @param u16ServiceId service ID
    /// @param u16ServerId server ID
    /// @param u16RegisterId ID of registered service
    /// @param u8ServiceState new state of service
    /// @param u16SubId sub identification number
    virtual void vOnServiceState(tU16 u16ServiceId,
        tU16 u16ServerId,
        tU16 u16RegisterId,
        tU8  u8ServiceState,
        tU16 u16SubId);

    // message handler for messages form a client to this server
    dia_tclService* poCcaService;

    // CCA Port Manager
    ahl_tclClientPortMngr *m_poPortMngr;

#ifndef __DIA_UNIT_TESTING__
    ail_tenCommunicationError enPostMyMessage(amt_tclServiceData *poMessage);
#endif

#ifndef VARIANT_S_FTR_DIAG_REMOVE_SESSION_POINTER
    // Diag sessions and pointer to active one
    dia_tclDiagSessionUds*   poDiagSessionUds;
    dia_tclDiagSession*      poDiagSession;
#endif

    // this pointer for use in static callback fncts
    static diagnostics_tclApp* poApp;

    // method to overwrite framework
    virtual void vOnCVMEvent (tU32 u32CVMEvent);

#ifndef __DIA_UNIT_TESTING__
    // framework
    static OSAL_tSemHandle     m_hNotTableSem;
    ahl_tclNotificationTable*  m_poNotTable;
#endif

private:
    void vClose();

private:
   //! pointer to the singleton object
    static diagnostics_tclApp* m_poServer;

   //! pointer to the internal diagnosis application
   dia_Application*    mpApp;
#ifndef __STARTUP_REFACTORING_ENABLE__
   //! pointer to the project specific factory (creates and provides access to project specific objects)
   dia_Factory* mpFactory;
#endif
};

#endif // __INCLUDED_DIA_MAIN__
